<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorRequirefile.php,v 1.4 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ɬܸڥ饹fileѡ
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorRequirefile.php,v 1.4 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorRequirefile extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'min_error' => null,
      'max_error' => null,
      'error1'    => null, // UPLOAD_ERR_INI_SIZE
      'error2'    => null, // UPLOAD_ERR_FORM_SIZE
      'error3'    => null, // UPLOAD_ERR_PARTIAL
      'error4'    => null, // UPLOAD_ERR_NO_FILE
      'error6'    => null, // UPLOAD_ERR_NO_TMP_DIR
      'error7'    => null  // UPLOAD_ERR_CANT_WRITE
    );

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param string о̾
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value, $name='')
    {
        if ($value === null) {
            // ե륢åץɰʳϡåʤ
            return true;
        }

        if ($this->max_valids == 0) {
            $this->max_valids = count($value['error']);
            if ($this->min_valids == 0) {
                $this->min_valids = count($value['error']);
            }
        }

        if (!$this->validate($value)) {
            $this->replaceErrorMessage($name);
            return false;
        } else {
            return true;
        }
    }

    /**
     * ɬܸڽ¹Ԥ
     *
     * @access public
     * @param array о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        // UPLOAD_ERR_OK ο
        $results = array_count_values($value['error']);
        $cnt = isset($results[UPLOAD_ERR_OK]) ? $results[UPLOAD_ERR_OK] : 0;
        if ($cnt < $this->min_valids) {
            if ($this->parameters['min_error'] !== null) {
                $this->error_message = $this->parameters['min_error'];
            }
            return false;
        }

        if ($cnt > $this->max_valids) {
            if ($this->parameters['max_error'] !== null) {
                $this->error_message = $this->parameters['max_error'];
            }
            return false;
        }

        // ե륢åץɸ२顼å
        for ($i=1; $i<=7; $i++) {
            if (isset($this->parameters['error'.$i])) {
                if (isset($results[$i])) {
                    if ($this->parameters['error'.$i] !== null) {
                        $this->error_message = $this->parameters['error'.$i];
                    }
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * ɬܸڽJavaScript
     *
     * @access public
     * @return string JavaScriptå
     */
    function getJsCode()
    {
        $min_error = $this->parameters['min_error'];
        $max_error = $this->parameters['max_error'];

        $options = array();
        $options[] = "'min_error': '{$min_error}'";
        $options[] = "'max_error': '{$max_error}'";
        $options[] = "'min_valids': '{$this->min_valids}'";
        $options[] = "'max_valids': '{$this->max_valids}'";

        $js  = '';
        $js .= 'if (!error_message) {' . "\n";
        $js .= '  var error_message_tmp = validation.isRequire(element_name, "' . $this->getErrorMessage() . '", {' . implode(',', $options) . '});' . "\n";
        $js .= '  if (error_message_tmp) {' . "\n";
        $js .= '    error_message = error_message_tmp;' . "\n";
        $js .= '  }' . "\n";
        $js .= '}' . "\n";
        return $js;
    }

}

?>
