<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComposite.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݥåȥѥ˴Ť쥯饹
 */
require_once 'SyL_UtilCompositeComponent.php';

/**
 * ݥåȥѥ˴Ťǥ롼ץ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComposite.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilCompositeComposite extends SyL_CompositeComponent
{
    /**
     * ǳǼ
     * 
     * @access private
     * @var array
     */
    var $entry = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object 
     */
    function SyL_CompositeComposite($name=null)
    {
        parent::SyL_CompositeComponent($name);
    }

    /**
     * Ǥɲä
     *
     * @access public
     * @param object 
     */
    function add($entry)
    {
        $this->entry[] = $entry;
    }

    /**
     * ĥ꡼ɽ
     *
     * @access public
     * @param int 
     */
    function printTree($depth=0)
    {
        echo str_repeat('    ', $depth);
        echo "+ {$this->name}\n";
        $depth++;
        foreach ($this->entry as $node) {
            $node->printTree($depth);
        }
    }

    /**
     * ĥ꡼
     *
     * @access public
     * @param array ĥ꡼ǡ
     */
    function getTree($tree=array())
    {
        $tree['name']       = $this->name;
        $tree['attributes'] = $this->getAttributes();
        $tree['nodes']      = array();
        foreach ($this->entry as $node) {
            $tree['nodes'][] = $node->getTree(array());
        }
        return $tree;
    }
}

?>
