<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendDefault.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼ؿ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendDefault.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSendDefault extends SyL_MailSend
{
    /**
     * ᡼¹
     *
     * @access public
     * @param object ᡼å֥
     * @return OK: true, NG: false
     */
    function send($message)
    {
        $from = $message->getFrom();
        $to   = $message->getTo();

        $additional_parameters = null;
        if (count($from) > 0) {
            // ꥿ѥΥå
            $additional_parameters = ' -f' . $from[0];
        } else {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        if (count($to) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }

        // ᡼¹
        if (!mail(null, $message->convertEncoding($message->getSubject(), true), null, $message->getMessage(), $additional_parameters)) {
            $this->error_message = "[SyL error] mail function error";
            return false;
        }

        return true;
    }
}

?>
