/**
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!SyL) var SyL = {};
if (!SyL.UI) SyL.UI = {};
if (!SyL.UI.Form) SyL.UI.Form = {};

/**
 * ե९饹
 */
SyL.UI.Form.Login = function(id, url)
{
  this.onsubmit = null;

  this.userNameLabel = "Username: ";
  this.passwordNameLabel = "Password: ";
  this.userName = "username";
  this.passwordName = "password";

  this.submitName = "OK";

  this.tableClass    = "syl-ui-login";
  this.errorMessageClass = "syl-ui-login-errormessage";
  this.userTextClass = "syl-ui-login-usertext";
  this.userPasswordClass = "syl-ui-login-passwordtext";

  this.autoFocus = true;

  if (!id || !document.getElementById(id)) {
    throw "[SyL.UI.LoginForm] Requre div id";
  }

  if (!url) {
    url = window.location.pathname;
  }

  this.initialize(url, id);
}

SyL.UI.Form.Login.prototype = {
  initialize: function(url, id)
  {
    var self = this;

    var ajax = false;

    var form = null;

    var key  = "";
    var hashFunc = "";

    var errorMessageTimer = null;

    var preLoginCallback = null;
    var postLoginCallback = null;

    var className = (/*@cc_on!@*/false) ? "className" : "class";

    this.setAjax = function (ajaxt)
    {
      if (typeof(SyL.Ajax) == "undefined") {
        throw "[SyL.UI.Form.Login.setAjax] SyL.Ajax package not imported";
      }
      ajax = !!ajaxt;
    };
    this.setPasswordHash = function (keyt, func)
    {
      key = keyt;
      if (typeof(func) == "function") {
        hashFunc = func;
      } else {
        throw "[SyL.UI.Form.Login.setHash] Invalid parameter (" + func + ")";
      }
    };
    this.setPreLoginCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        preLoginCallback = callback;
      } else {
        throw "[SyL.UI.Form.Login.setPreLoginCallback] Invalid parameter (" + callback + ")";
      }
    };
    this.setPostLoginCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        postLoginCallback = callback;
      } else {
        throw "[SyL.UI.Form.Login.setPostLoginCallback] Invalid parameter (" + callback + ")";
      }
    };

    this.create = function(formId, userValue, passwordValue)
    {
      if (typeof(userValue) == "undefined") {
        userValue = "";
      }
      if (typeof(passwordValue) == "undefined") {
        passwordValue = "";
      }

      var div = document.getElementById(id);

      var dive = document.createElement("div");
      dive.setAttribute(className, this.errorMessageClass);
      dive.style.display = "none";
      dive.innerHTML = "&nbsp;";

      form  = document.createElement("form");
      if (formId) {
        form.id   = formId;
        form.name = formId;
      }
      form.style.padding = "0px";
      form.style.margin  = "0px";
      form.method = "POST";
      form.action = url;
      form.onsubmit = function() {
        return self.submit(this);
      };
      var table = document.createElement("table");
      table.setAttribute(className, this.tableClass);
      var tbody = document.createElement("tbody");
      var tr = document.createElement("tr");
      var th = document.createElement("th");
      th.innerHTML = this.userNameLabel;
      tr.appendChild(th);
      var td = document.createElement("td");
      this.createUserText(td, userValue);
      tr.appendChild(td);
      tbody.appendChild(tr);

      var tr = document.createElement("tr");
      var th = document.createElement("th");
      th.innerHTML = this.passwordNameLabel;
      tr.appendChild(th);
      var td = document.createElement("td");
      this.createPasswordText(td, passwordValue);
      tr.appendChild(td);
      tbody.appendChild(tr);

      var tr = document.createElement("tr");
      var td = document.createElement("td");
      td.colSpan = "2";
      td.style.textAlign = "right";
      var input = document.createElement("input");
      input.type  = "submit";
      input.value = this.submitName;
      td.appendChild(input);
      tr.appendChild(td);
      tbody.appendChild(tr);

      form.appendChild(table);
      table.appendChild(tbody);
      div.appendChild(dive);
      div.appendChild(form);

      if (this.autoFocus) {
        this.focusInput();
      }
    };

    this.createUserText = function(element, value)
    {
      if (typeof(element) != "object") {
        throw "[SyL.UI.Form.Login.createUserText] Invalid parameter format (" + typeof(element) + ")";
      }
      var input = document.createElement("input");
      input.setAttribute(className, this.userTextClass);
      input.type  = "text";
      input.name  = this.userName;
      input.value = value;
      element.appendChild(input);
    };

    this.createPasswordText = function(element, value)
    {
      if (typeof(element) != "object") {
        throw "[SyL.UI.Form.Login.createPasswordText] Invalid parameter format (" + typeof(element) + ")";
      }
      var input   = document.createElement("input");
      input.setAttribute(className, this.userPasswordClass);
      input.type  = "password";
      input.name  = this.passwordName;
      input.value = value;
      element.appendChild(input);
    };

    this.getUserElement = function()
    {
      return getElement(this.userName);
    };

    this.getPasswordElement = function()
    {
      return getElement(this.passwordName);
    };

    function getElement(inputName)
    {
      if (form) {
        for (var i=0; i<form.elements.length; i++) {
          if (form.elements[i].name == inputName) {
            return form.elements[i];
          }
        }
      }
      return null;
    };

    this.submit = function()
    {
      var userValue     = getElement(this.userName).value;
      var passwordValue = getElement(this.passwordName).value;

      if (preLoginCallback && !preLoginCallback(userValue, passwordValue)) {
        return false;
      }

      this.enableSubmit(false);

      if (ajax) {
        if (key) {
          passwordValue = getPasswordHash(passwordValue);
        }
        requestAjax(userValue, passwordValue);
        return false;
      } else {
        var input = document.createElement("input");
        input.type  = "hidden";
        input.name  = this.userName;
        input.value = userValue;
        form.appendChild(input);

        var input = document.createElement("input");
        input.type  = "hidden";
        input.name  = this.passwordName;
        input.value = (key ? getPasswordHash(passwordValue) : passwordValue);
        form.appendChild(input);

        return true;
      }
    };

    this.focusInput = function()
    {
      var timer = setTimeout(function() {
        var user     = getElement(self.userName);
        var password = getElement(self.passwordName);

        if ((!user || user.value == "") || ((user && user.value != "") && (password && password.value != ""))) {
          user.focus();
        } else {
          password.focus();
        }
        clearTimeout(timer);
      }, 100);
    };

    this.enableSubmit = function(enable)
    {
      for (var i=0; i<form.elements.length; i++) {
          form.elements[i].disabled = !enable;
      }
    };

    function requestAjax(userValue, passwordValue)
    {
      var userinfo = {};
      userinfo[self.userName] = userValue;
      userinfo[self.passwordName] = passwordValue;

      SyL.Ajax.Request.sendAsyncPost(
        url,
        function(data){
          self.enableSubmit(true);
          if (self.autoFocus) {
            self.focusInput();
          }
          if (postLoginCallback) {
            postLoginCallback(data);
          }
        },
        userinfo
      );
    };

    function getPasswordHash(passwordValue)
    {
       return hashFunc(key + hashFunc(passwordValue));
    };

    this.displayErrorMessage = function (errorMessage, timeout)
    {
      var div = document.getElementById(id);
      if (errorMessage) {
        div.firstChild.style.display = "block";
        div.firstChild.innerHTML = errorMessage;

        if (typeof(timeout) != "number") {
          timeout = 0;
        }
        if (timeout > 0) {
          if (errorMessageTimer) {
            clearTimeout(errorMessageTimer);
            errorMessageTimer = null;
          }
          errorMessageTimer = setTimeout(function(){
            div.firstChild.style.display = "none";
            clearTimeout(errorMessageTimer);
            errorMessageTimer = null;
          }, timeout);
        }
      } else {
        div.firstChild.style.display = "none";
        div.firstChild.innerHTML = "";
      }
    };
  }
}
