/**
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!SyL) var SyL = {};
if (!SyL.Event) SyL.Event = {};

/**
 * ٥ȴ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
SyL.Event.Listener = {
  cache: {},
  add: function(element, eventName, handler)
  {
    if (element.addEventListener) {
      element.addEventListener(eventName, handler, false);
    } else if (element.attachEvent) {
      element.attachEvent('on'+eventName, handler);
    }
    if (element.id) {
      var id = element.id;
      if (!SyL.Event.Listener.cache[id]) {
        SyL.Event.Listener.cache[id] = {};
      }
      if (!SyL.Event.Listener.cache[id][eventName]) {
        SyL.Event.Listener.cache[id][eventName] = [];
      }
      SyL.Event.Listener.cache[id][eventName].push(handler);
    }
  },
  remove: function(element, eventName, handler)
  {
    if (eventName && handler) {
      if (element.removeEventListener) {
        element.removeEventListener(eventName, handler, false);
      } else if (element.detachEvent) {
        element.detachEvent('on'+eventName, handler);
      }
    } else if (element.id) {
      var id = element.id;
      if (eventName) {
        var len = SyL.Event.Listener.cache[id][eventName].length;
        for (var i=0; i<len; i++) {
          SyL.Event.Listener.remove(element, eventName, SyL.Event.Listener.cache[id][eventName][i]);
        }
      } else {
        for (var name in SyL.Event.Listener.cache[id]) {
          SyL.Event.Listener.remove(element, name);
        }
      }
    } else {
      for (var elem in SyL.Event.Listener.cache) {
        SyL.Event.Listener.remove(elem);
      }
    }
  }
}

/**
 * ǥ󥰥饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
SyL.Event.Loading = function(id)
{
  this.initialize(id);
};

SyL.Event.Loading.prototype = {
  initialize: function(id)
  {
    var timer = null;
    var timeout = 500;

    var startCallback    = null;
    var loadingCallback  = null;
    var completeCallback = null;

    this.setStartCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        startCallback = callback;
      } else {
        throw "[SyL.Event.Loading.setStartCallback] Invalid callback parameter";
      }
    };
    this.setLoadingCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        loadingCallback = callback;
      } else {
        throw "[SyL.Event.Loading.setLoadingCallback] Invalid callback parameter";
      }
    };
    this.setCompleteCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        completeCallback = callback;
      } else {
        throw "[SyL.Event.Loading.setCompleteCallback] Invalid callback parameter";
      }
    };
    this.start = function(resource)
    {
      if (!document.getElementById(id)) {
        var div = document.createElement('div');
        div.innerHTML = '<iframe src="javascript:false;" style="display:none;" id="' + id + '" name="' + id + '"></iframe>';
        document.body.appendChild(div);
      }

      SyL.Event.Listener.add(document.getElementById(id), "load", function () {
        var iframe = document.getElementById(id);
        iframedoc = (document.all) ? iframe.contentWindow.document : iframe.contentDocument;
        if (iframedoc.location.href == "javascript:false;") {
          return;
        }

        loadingCallback = null;
        if (timer) {
          clearTimeout(timer);
          timer = null;
        }
        SyL.Event.Listener.remove(document.getElementById(id), "load");
        if (completeCallback) {
          completeCallback();
          completeCallback = null;
        }
      });

      if (startCallback) {
          startCallback();
      }
      if (loadingCallback) {
        loading();
      }

      if (typeof(resource) == "object") {
        resource.target = id;
      } else {
        document.getElementById(id).src = resource;
      }
    };
    function loading()
    {
      if (loadingCallback) {
        loadingCallback();
        timer = setTimeout(loading, timeout);
      }
    };
  }
}
