<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewXmlrpc.php,v 1.4 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPCӥ塼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewXmlrpc.php,v 1.4 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewXmlrpc extends SyL_View
{
    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        // ƥĥפ򥻥å
        $this->setContentType('text/xml; charset=' . SYL_ENCODE_XMLRPC);

        // 쥹ݥXML
        $xml = '';
        // 󤫤Υѥ᡼
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key]) && is_a($values[$key], 'SyL_XmlRpcBuilderServer')) {
                $values[$key]->setEncoding(SYL_ENCODE_XMLRPC);
                $xml = $values[$key]->build();
                break;
            }
        }

        if (!$xml) {
            trigger_error("[SyL error] SyL_XmlRpcBuilderServer Object not found", E_USER_ERROR);
        }

        // 쥹ݥXML򥻥å
        $this->setRender($xml);
    }
}

?>
