<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowNew.php,v 1.8 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowNew.php,v 1.8 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowNew extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'new';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowNew()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ե
        $form =& $this->getForm();
        // DB³
        $conn =& $context->getDB();
        // ADM֥Ⱥ
        $adm  =& SyL_Adm::factory($form, $conn);
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isNew()) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // ɽΤ
        $read_only = '';
        if (!$data->get('adm_action_exe')) {
            $read_only = $data->get('adm_read_only');
            if ($read_only) {
                foreach (explode("\t", $read_only) as $column) {
                    $form->setReadOnlyColumn($column);
                }
            }
        }

        // Ϣǡ󥯤ѥ
        list($pu, $cu, $nu) = $this->getLocations($data->get('adm_u'));

        // ǡ֥ȥå
        $form->registerInput($data);
        // ե๽
        $form->build(!$context->isPost());

        // ʬ
        if ($context->isPost()) {
            // ؿʤ
            if ($data->get('adm_action_next')) {
                // Хǡ¹
                if ($this->validate($adm)) {
                    // ǧ̤
                    $form->setReadOnly(true);
                }
            } else if ($data->get('adm_action_exe')) {
                // Хǡ¹
                if ($this->validate($adm)) {
                    // Ͽ¹
                    $this->insert($adm);
                    // λ̤إ쥯
                    SyL_Response::redirect($this->getUrl('fin') . '?adm_action=new&adm_u=' . urlencode($data->get('adm_u')));
                }
            } else if ($data->get('adm_action_prev')) {
                // ǧ̤
            }
        } else {
            // ɽ
        }

        // DB³λ
        $context->closeDB($conn);

        // եǥǡ
        $data->set('form',      $form->getResultArray());
        $data->set('read_only', $read_only);
        // ǧɽϢ
        $data->set('view_alert',   $form->getStructConfig('view_alert'));
        $data->set('view_confirm', $form->getStructConfig('view_confirm'));

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_new', $this->getUrl('new'));
        $data->set('url_dir', dirname($this->getScriptName()));
        $data->set('url_lst_u', $this->getUrl('lst', $pu));

        // Ϣǡ󥯤ѥ
        $data->set('cu',  $cu);
        $data->set('cuu', $data->get('adm_u'));
    }

    /**
     * Хǡ¹
     *
     * @access public
     * @param object ADM֥
     * @return bool true: ХǡOKfalse: Хǡ󥨥顼
     */
    function validate(&$adm)
    {
        return $adm->validate();
    }

    /**
     * Ͽ¹
     *
     * @access public
     * @param object ADM֥
     */
    function insert(&$adm)
    {
        $adm->insert();
    }
}

?>
