<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilProperty.php,v 1.3 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilProperty.php,v 1.3 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilProperty
{
    /**
     * ץѥƥ
     * 
     * @access private
     * @var array
     */
    var $parameters = array();

    /**
     * ץѥƥ򥻥å
     * 
     * @access public
     * @param string ץѥƥ̾
     * @param string ץѥƥ
     */
    function set($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * ץѥƥ򥻥åȡʻȡ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @param string ץѥƥ
     */
    function setRef($name, &$value)
    {
        $this->parameters[$name] =& $value;
    }

    /**
     * ʣץѥƥ򥻥å
     * 
     * @access public
     * @param array ץѥƥ
     */
    function sets($values)
    {
        $this->parameters = array_merge($this->parameters, $values);
    }

    /**
     * ʣץѥƥ򥻥åȡʻȡ
     * 
     * @access public
     * @param array ץѥƥ
     */
    function setsRef(&$values)
    {
        foreach (array_keys($values) as $name) {
            $this->parameters[$name] =& $values[$name];
        }
    }

    /**
     * ץѥƥ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return string ץѥƥ
     */
    function get($name)
    {
        if (isset($this->parameters[$name])) {
            return $this->parameters[$name];
        } else {
            return null;
        }
    }

    /**
     * ץѥƥʻȡ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return string ץѥƥ
     */
    function &getRef($name)
    {
        $value = null;
        if (isset($this->parameters[$name])) {
            $value =& $this->parameters[$name];
        }
        return $value;
    }

    /**
     * ץѥƥ
     * 
     * @access public
     * @return array ץѥƥ
     */
    function gets()
    {
        return $this->parameters;
    }

    /**
     * ץѥƥʻȡ
     * 
     * @access public
     * @return array ץѥƥ
     */
    function &getsRef()
    {
        return $this->parameters;
    }

    /**
     * ץѥƥ
     * 
     * @access public
     * @param string ץѥƥ̾
     */
    function delete($name)
    {
        if (isset($this->parameters[$name])) {
            unset($this->parameters[$name]);
        }
    }

    /**
     * ץѥƥ
     * 
     * @access public
     */
    function deletes()
    {
        $this->parameters = array();
    }

    /**
     * ץѥƥγǧ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return bool true: ץѥƥꡢfalse: ץѥƥ̵
     */
    function is($name)
    {
        return isset($this->parameters[$name]);
    }

    /**
     * ץѥƥο
     * 
     * @access public
     * @return int ץѥƥο
     */
    function length()
    {
        return count($this->parameters);
    }

    /**
     * ѥ᡼˻ؿŬѤ
     * 
     * @access private
     * @param array ѥ᡼
     * @param string ؿ̾
     */
    function apply($func)
    {
        $func_parameters = func_get_args();
        $func = array_shift($func_parameters);
        $this->applyRecursive($func, $this->parameters, $func_parameters);
    }

    /**
     * ѥ᡼˻ؿŬѤ
     * 
     * @access private
     * @param string ؿ̾
     * @param array ѥ᡼
     * @param array ؿѥ᡼
     */
    function applyRecursive($func, &$parameters, $args)
    {
        if (is_array($parameters)) {
            foreach($parameters as $key => $value) {
                $this->applyRecursive($func, $parameters[$key], $args);
            }
        } else {
            if (is_scalar($parameters)) {
                $parameters = call_user_func_array($func, array_merge((array)$parameters, $args));
            }
        }
    }
}

?>
