<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.11 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.11 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigLayouts extends SyL_Config
{
    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_CACHE) {
            // åѤ
            $key = SYL_APP_DIR . $this->context->getActionFile();
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }

        if (!isset($this->config['file'])) {
            // б쥤ȥޥåԥ󥰤¸ߤʤ
            trigger_error("[SyL error] Layout mapping not found (Layout name: " . $this->context->getLayoutName() . ")", E_USER_ERROR);
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $layout    = 0;
        static $parameter = 0;

        // 1ɺѤߤξʹߥå
        if ($layout > 1) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-layouts/layout':
            if ($layout == 1) {
                $layout = 2;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // 쥤̾Ƚ
            if ($attribute['name'] == $this->context->getLayoutName()) {
                $layout = 1;
                $this->config['file']       = $attribute['file'];
                $this->config['templates']  = array();
                $this->config['content']    = array();
                $this->config['parameters'] = array();
            }
            break;

        default:
            if ($layout == 0) return;

            switch ($current_path) {
            case '/syl-layouts/layout/template':
                $this->config['templates'][$attribute['name']] = $attribute['file'];
                break;

            case '/syl-layouts/layout/content':
                $this->config['content'] = $attribute['name'];
                break;

            case '/syl-layouts/layout/params/action':
                if ($parameter > 1) return;
                if ($parameter == 1) {
                    $parameter = 2;
                    return;
                }
                $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
                if (preg_match('/^' . $reg . '$/', $this->context->getActionFile())) {
                    $parameter = 1;
                }
                break;

            case '/syl-layouts/layout/params/action/param':
                if ($parameter == 1) {
                    // ɲŪѥ᡼
                    $this->config['params'][$attribute['name']] = $attribute['value'];
                }
                break;
            }
        }
    }
}

?>
