<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilJson.php,v 1.3 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!function_exists('json_encode')) {
function json_encode($value)
{
    return preg_replace('/(\r\n|\r|\n)/', '\\\n', SyL_UtilJson::encode($value));
}
}

/**
 * Json饹
 *
 * 󥳡ɤΤߡ5.2ʾǤϻѤʤɸΤǡ
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilJson.php,v 1.3 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilJson
{
    /**
     * PHPѿJSON˥󥳡ɤ
     *
     * @static
     * @access public
     * @param mixed Ѵо
     * @return string Ѵ
     */
    function encode($value)
    {
        $class_name = __CLASS__;
        if (is_string($value)) {
            return call_user_func(array($class_name, 'encodeString'), $value);
        } else if (is_int($value) || is_float($value)) {
            return call_user_func(array($class_name, 'encodeNumber'), $value);
        } else if (is_bool($value)) {
            return call_user_func(array($class_name, 'encodeBoolean'), $value);
        } else if (is_null($value)) {
            return call_user_func(array($class_name, 'encodeNull'), $value);
        } else if (is_array($value)) {
            return call_user_func(array($class_name, 'encodeArray'), $value);
        } else if (is_object($value)) {
            return call_user_func(array($class_name, 'encodeObject'), $value);
        } else {
            trigger_error("[SyL error] invalid format (" . gettype($value) . ")", E_USER_ERROR);
        }
    }

    /**
     * ʸJSONʸѴ
     *
     * @access public
     * @static
     * @param string Ѵ
     * @return string Ѵ
     */
    function encodeString($value)
    {
        return "\"" . preg_replace('/(\"|\\\\)/', '\\\\$1', $value) . "\"";
    }

    /**
     * ͤJSONʸѴ
     *
     * @access public
     * @static
     * @param int Ѵ
     * @return string Ѵ
     */
    function encodeNumber($value)
    {
        return (string)$value;
    }

    /**
     * JSONʸѴ
     *
     * @access public
     * @static
     * @param bool Ѵ
     * @return string Ѵ
     */
    function encodeBoolean($value)
    {
        return ($value) ? "true" : "false";
    }

    /**
     * NULLJSONʸѴ
     *
     * @access public
     * @static
     * @param null Ѵ
     * @return string Ѵ
     */
    function encodeNull($value)
    {
        return "null";
    }

    /**
     * JSONʸѴ
     *
     * @access public
     * @static
     * @param array Ѵ
     * @return string Ѵ
     */
    function encodeArray($value)
    {
        $class_name = __CLASS__;
        $len = count($value);
        if ($len > 0) {
            if (array_keys($value) === range(0, $len-1)) {
                return '[' . join(',', array_map(array($class_name, 'encode'), $value)) . ']';
            } else {
                return call_user_func(array($class_name, 'encodeObject'), $value);
            }
        } else {
            return "[]";
        }
    }

    /**
     * ֥ȤJSONʸѴ
     *
     * @access public
     * @static
     * @param object Ѵ
     * @return string Ѵ
     */
    function encodeObject($value)
    {
        $class_name = __CLASS__;
        $result = array();
        foreach ($value as $key => $variant) {
            $result[] = call_user_func(array($class_name, 'encode'), (string)$key) . ':'
                      . call_user_func(array($class_name, 'encode'), $variant);
        }
        return '{' . join(',', $result) . '}';
    }
}

?>
