<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdooci.php,v 1.1 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹PDO
 */
require_once 'SyL_DBPdo.php';

/**
 *  DB饹PDO::Oci
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdooci.php,v 1.1 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBPdooci extends SyL_DBPdo
{
    /**
     * 󥳡Ѵơ֥
     *
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'japanese_japan.ja16euc'),
      array('euc-jp',    'japanese_japan.ja16euc'),
      array('euc',       'japanese_japan.ja16euc'),
      array('sjis-win',  'japanese_japan.ja16sjis'),
      array('sjis',      'japanese_japan.ja16sjis'),
      array('utf-8',     'japanese_japan.utf8')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    public function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $conn_dbtype  = substr($this->dbname, 3);
        $conn_strings = array();
        $conn_user    = null;
        $conn_passwd  = null;
        if ($host) {
            $conn_strings[] = ($port) ? "dbname={$host}:{$port}/$dbname" : "dbname={$host}/$dbname";
        } else {
            $conn_strings[] = "dbname={$dbname}";
        }
        if ($user && $passwd) {
            $conn_user   = $user;
            $conn_passwd = $passwd;
        } else if ($user) {
            $conn_user = $user;
        }

        $conn_string = $conn_dbtype . ':' . implode(';', $conn_strings);
        return $this->pdoConnection($conn_string, $conn_user, $conn_passwd);
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    public function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  =  "";
        $sql_page .= "SELECT ";
        $sql_page .=   "SyL2$.* ";
        $sql_page .= "FROM ";
        $sql_page .=   "(";
        $sql_page .=     "SELECT ";
        $sql_page .=       "SyL$.*, ";
        $sql_page .=       "ROWNUM as ROWNUM$ ";
        $sql_page .=     "FROM ";
        $sql_page .=       "(" . $sql . ") SyL$ ";
        $sql_page .=   ") SyL2$ ";
        $sql_page .= "WHERE ";
        $sql_page .=   "ROWNUM$ BETWEEN " . ($pager->getStartOffset() + 1) . " AND " . ($pager->getStartOffset() + $pager->getCount());

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    public function getVersion()
    {
        $sql = 'SELECT BANNER FROM V$VERSION';
        $this->queryRef($sql, $versions, 'one');
        $version = false;
        if (preg_match ('/ ([\d\.]+) \-/', $versions, $matches)) {
            $version = $matches[1];
        }
        return $version;
    }
}

?>
