<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.2 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե९饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_Form.php';

/**
 * ե९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.2 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ActionForm extends SyL_Form
{
    /**
     * ե̾
     * 
     * @access protected
     * @var string
     */
    var $name = "syl_form";
    /**
     * ե
     * 
     * @access protected
     * @var array
     */
    var $form_config = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param mixed ѥ᡼ؿ
     */
    function SyL_ActionForm($action='', $callback_parameter=null)
    {
        parent::SyL_Form($this->name, $action);

        if ($callback_parameter) {
            $this->setCallbackParameter($callback_parameter);
        }

        if (is_array($this->form_config)) {
            foreach ($this->form_config as $name => $values) {
                $type         = $values['type'];
                $display_name = isset($values['display_name']) ? $values['display_name'] : $name;
                $options      = isset($values['options'])      ? $values['options']      : array();
                $attributes   = isset($values['attributes'])   ? $values['attributes']   : array();
                // Ǻ
                $element =& $this->createElement($type, $name, $display_name, $options, $attributes);
                if (isset($values['validate']) && (count($values['validate']) > 0)) {
                    $vs =& SyL_Validators::create();
                    foreach ($values['validate'] as $v_name => $v_values) {
                        $v_parameters = isset($v_values['parameters']) ? $v_values['parameters'] : array();
                        $vs->add(SyL_Validator::create($v_name, $v_values['message'], $v_parameters));
                    }
                    $element->setValidators($vs);
                }
                $this->addElement($element);
            }
        } else {
            trigger_error("[SyL error] Invalid form config (" . var_export($this->form_config) . ")", E_USER_ERROR);
        }
    }

    /**
     * ե᥽å
     *
     * @access public
     * @param string ե४֥̾
     * @param string URL
     * @param mixed ѥ᡼ؿ
     * @return object ե४֥
     */
    function &factory($formname, $action='', $callback_parameter=null)
    {
        $formname = ucfirst($formname);
        include_once SYL_PROJECT_LIB_DIR . "/forms/{$formname}.php";
        $form =& new $formname($action, $callback_parameter);
        return $form;
    }

}

?>
