<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerJs.php,v 1.6 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptϥȥ饯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerJs.php,v 1.6 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ControllerJs extends SyL_Controller
{
    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        $config_files = array();
        // Х륳ݡͥե
        $config_files['components'][] = SYL_PROJECT_CONFIG_DIR . "/{$this->components_file_name}";
        // ٥ȼ¹
        $this->raiseEvent('initStream', $config_files);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function loadStream()
    {
        $config_files = array();
        // ץꥱե륿ե
        $config_files['filters'][] = SYL_APP_DIR . "/{$this->filter_file_name}";
        if (!file_exists($config_files['filters'][0])) {
            array_shift($config_files['filters']);
        }
        // Хե륿ե
        $config_files['filters'][] = SYL_PROJECT_CONFIG_DIR . "/{$this->filter_file_name}";

        // ٥ȼ¹
        $this->raiseEvent('loadStream', $config_files);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        $config_files = array();
        // ե
        $config_files['actions'][] = SYL_APP_DIR . "/{$this->action_file_name}";

        // ٥ȼ¹
        $this->raiseEvent('executeStream', $config_files);
    }

    /**
     * ȥݥ
     *
     * @access public
     */
    function stream()
    {
        // 
        $this->initStream();
        // ¹
        $this->loadStream();
        // ¹Խ
        $this->executeStream();
        // ӥ塼ɽ¹
        $this->middleStream();
        // ӥ塼ɽ¹
        $this->renderStream();
        // ӥ塼ɽ¹Ը
        $this->unloadStream();
    }
}

?>
