<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Logger.php,v 1.9 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ϥ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Logger.php,v 1.9 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Logger
{
    /**
     * ꥯȥ᥽å
     * 
     * @access public
     * @var string
     */
    var $request_method;
    /**
     * 饤IPɥ쥹
     * 
     * @access public
     * @var string
     */
    var $remote_addr;
    /**
     * ꥯURL
     * 
     * @access public
     * @var string
     */
    var $request_uri;
    /**
     * ¨ϥե饰
     * 
     * @access public
     * @var bool
     */
    var $immediate = true;
    /**
     * ¨ϤǤϤʤ˳ǼХåե
     * 
     * @access public
     * @var array
     */
    var $buffer = array();
    /**
     * ԥ
     * 
     * @access public
     * @var string
     */
    var $eof = "\r\n";

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param boolean ¨ϥե饰 true: ¨ϡfalse: ꥯȽλ˽
     */
    function SyL_Logger($immediate=true)
    {
        $this->request_method = isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : '';
        $this->remote_addr    = isset($_SERVER['REMOTE_ADDR'])    ? $_SERVER['REMOTE_ADDR']    : '';
        $this->request_uri    = isset($_SERVER['REQUEST_URI'])    ? $_SERVER['REQUEST_URI']    : '';
        $this->immediate = $immediate;
    }

    /**
     * ֥Ȥμ
     *
     * @access public
     * @param string ƥ̾
     * @param boolean ¨ϥե饰 true: ¨ϡfalse: ꥯȽλ˽
     * @return object ֥
     */
    function &getLogger($type, $immediate=true)
    {
        // ƥꥪ֥ɤ߹
        $logger_class = 'SyL_Logger' . ucfirst($type);
        include_once SYL_INCLUDE_DIR . '/framework/Logger/' . $logger_class . '.php';
        $logger_object =& new $logger_class($immediate);
        return $logger_object;
    }

    /**
     * ץ
     *
     * @access public
     */
    function open()
    {
    }

    /**
     * ν
     *
     * @access public
     * @param string ٥̾
     * @param string å
     */
    function log($level, $message)
    {
    }

    /**
     * 
     *
     * @access public
     */
    function logAll()
    {
        if (!$this->immediate) {
            while (true) {
                $buffer = array_shift($this->buffer);
                if (($buffer === false) || ($buffer === null)) {
                    break;
                }
                $this->log( '', $buffer );
            }
        }
    }

    /**
     * Ĥ
     *
     * @access public
     */
    function close()
    {
        $this->logAll();
    }

}

?>
