<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.15 2007/02/22 12:55:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹९饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Config.php';

/**
 * ̹ǥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.15 2007/02/22 12:55:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_View
{
    /**
     * 쥤ե̾
     * 
     * @access private
     * @param string
     */
    var $layout_file_name = 'layouts.xml';
    /**
     * ե
     * 
     * @access private
     * @var array
     */
    var $config = array();
    /**
     * ƥĥ
     * 
     * @access protected
     * @var string
     */
    var $content_type = '';
    /**
     * ƥ̽Ƚ
     * 
     * @access protected
     * @var bool
     */
    var $content_length = true;
    /**
     * gzipȽ
     * 
     * @access protected
     * @var bool
     */
    var $gzip_compress = true;
    /**
     * ɽƤΥǡ
     * 
     * @access protected
     * @var string
     */
    var $render = '';
    /**
     * ǡ֥
     * 
     * @access protected
     * @var object
     */
    var $dm = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ǡ֥
     */
    function SyL_View(&$dm)
    {
        $this->dm =& $dm;
    }

    /**
     * ƥץ졼ȥ֥Ȥ
     * 
     * @access public
     * @param object ǡ֥
     * @param object ݡͥȥ᥽åɥ֥
     * @return object ӥ塼֥
     */
    function &getObject(&$dm)
    {
        $view = null;
        $type = $dm->getViewParameter('viewtype');
        if ($dm->getViewParameter('viewlayout') === 'true') {
            // Layout 饹
            switch ($type) {
            case 'smarty' : $class_name = 'SyL_ViewLayoutSmarty';  break;
            case 'default': $class_name = 'SyL_ViewLayoutDefault'; break;
            default: trigger_error("[SyL error] Layout type not found ({$type})", E_USER_ERROR);
            }
            $class_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
            include_once $class_file;
            $view =& new $class_name($dm);
            $view->parseConfig($dm->controller);
        } else {
            switch ($type) {
            case 'customize':
                $class_name = $dm->getViewParameter('customizedviewclass');
                $class_file = $dm->getViewParameter('customizedviewfile');
                if (!is_file($class_file)) {
                    $class_file1 = SYL_WEBAPP_LIB_DIR . "/{$class_file}";
                    if (!is_file($class_file1)) {
                        trigger_error("[SyL error] Customised View file not found ({$class_file} or {$class_file1})", E_USER_ERROR);
                    }
                    $class_file = $class_file1;
                }
                break;
            case 'smarty':
                $class_name = 'SyL_ViewSmarty';
                $class_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
                break;
            case 'js':
                $class_name = 'SyL_ViewJs';
                $class_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
                break;
            case 'ajax':
                $class_name = 'SyL_ViewAjax';
                $class_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
                break;
            case 'json':
                $class_name = 'SyL_ViewJson';
                $class_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
                break;
            case 'default':
                $class_name = 'SyL_ViewDefault';
                $class_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
                break;
            default:
                trigger_error("[SyL error] View type not found ({$type})", E_USER_ERROR);
            }

            include_once $class_file;
            $view =& new $class_name($dm);
        }

        return $view;
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseConfig(&$controller)
    {
        $config_file = SYL_APP_DIR . "/{$this->layout_file_name}";
        $reader =& SyL_Config::getObject('layouts', $config_file, $controller);
        $reader->parseXML();
        $this->config += $reader->getConfig();
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->dm->getTemplateDir();
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        if ($this->dm->getViewParameter('viewlayout') === 'true') {
            return $this->config['file'];
        } else {
            return $this->dm->getTemplateFile();
        }
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getActionValues()
    {
        $values = array();

        // 쥤
        if (isset($this->config['templates'])) {
            $values += $this->config['templates'];
        }
        if (isset($this->config['view'])) {
            foreach (array_keys($this->config['view']) as $template) {
                $values[$template] = $this->dm->getTemplateFile();
            }
        }
        if (isset($this->config['parameters'])) {
            $values += $this->config['parameters'];
        }

        // ͤʤ
        $values += $this->dm->getParameters();

        return $values;
    }

    /**
     * ӥ塼ɽ󥯥롼ɥե
     * 
     * @access public
     * @return array ӥ塼ɽ󥯥롼ɥե
     */
    function getIncludeFiles()
    {
        if (isset($this->config['includes']) && is_array($this->config['includes'])) {
            return array_map(create_function('$a', 'return "' . $this->dm->getActionDir() . '/" . $a;'), $this->config['includes']);
        } else {
            return array();
        }
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
    }

    /**
     * ƥĥפ򥻥å
     * 
     * @access public
     * @param string ƥĥ
     */
    function setContentType($content_type)
    {
        $this->content_type = $content_type;
    }

    /**
     * ƥĥפ
     * 
     * @access public
     * @return string ƥĥ
     */
    function getContentType()
    {
        return $this->content_type;
    }

    /**
     * ƥ̽Ƚ
     * 
     * @access public
     * @return bool ƥ̽Ƚ
     */
    function isContentLength()
    {
        return (SYL_RESPONSE_LENGTH) ? $this->content_length : false;
    }

    /**
     * gzipȽ
     * 
     * @access public
     * @return bool gzipȽ
     */
    function isGzipCompress()
    {
        return (SYL_RESPONSE_GZIP) ? $this->gzip_compress : false;
    }

    /**
     * ɽƤ򥻥å
     * 
     * @access public
     * @param string ɽ
     */
    function setRender(&$render)
    {
        $this->render =& $render;
    }

    /**
     * ɽƤ
     * 
     * @access public
     * @return string HTML
     */
    function &getRender()
    {
        return $this->render;
    }

    /**
     * ɽƤ
     * 
     * @access public
     */
    function clearRender()
    {
        unset($this->render);
        $this->render = '';
    }
}


?>
