<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LoggerFile.php,v 1.9 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե񤭹ߥ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_FileWriter.php';

/**
 * եؤΥϥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LoggerFile.php,v 1.9 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_LoggerFile extends SyL_Logger
{
    /**
     * SyL_File֥
     * 
     * @access public
     */
    var $writer = null;

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param boolean ¨ϥե饰 true: ¨ϡfalse: ꥯȽλ˽
     */
    function SyL_LoggerFile($immediate)
    {
        parent::SyL_Logger($immediate);
    }

    /**
     * ץ
     *
     * @access public
     * @param string ե̾
     */
    function open($filename)
    {
        // ե̾Ѵ
        $filename = str_replace('YYYY', date('Y'), $filename);
        $filename = str_replace('MM',   date('m'), $filename);
        $filename = str_replace('DD',   date('d'), $filename);

        if ($this->writer == null) {
            $this->writer = new SyL_FileWriter($filename);
            $this->writer->open('ab');
        }
    }

    /**
     * ν
     *
     * @access public
     * @param string ٥̾
     * @param string å
     */
    function log($level, $message)
    {
        if ($level != '') {
            $message = sprintf ('%s [%s] %s "%s %s" %s', date('Y-m-d H:i:s'), $level, $this->remote_addr, $this->request_method, $this->request_uri, rtrim($message));
        }
        if ($this->immediate || ($level == '')) {
            $this->writer->write($message . $this->eof);
        } else {
            $this->buffer[] = $message;
        }
    }

    /**
     * եĤ
     *
     * @access public
     */
    function close()
    {
        if ($this->writer != null) {
            parent::close();
            $this->writer->close();
            $this->writer = null;
        }
    }
}

?>
