<?php
/**
 * եݡͥȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: C_CreateAction.php,v 1.6 2007/01/21 08:14:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class C_CreateAction
{
    /**
     * ե
     *
     * @access public
     * @param string ץȥǥ쥯ȥ
     * @param string ץꥱ̾
     * @param string ե
     */
    function trigger($project_dir, $app_name, $action_file)
    {
        $action_dir = "{$project_dir}app/{$app_name}/actions";
        if (!is_dir($action_dir)) {
            echo "  creating directory {$action_dir}\n"; ob_flush();
            if (!mkdir($action_dir, 0755)) {
                trigger_error("[SyL error] action directory can't create ({$action_dir})", E_USER_ERROR);
                exit;
            }
        }

        if (file_exists("{$project_dir}var/skel-templates/action.php")) {
            $action_template = "{$project_dir}var/skel-templates/action.php";
        } else {
            $action_template = SYL_WEBAPP_DIR . '/var/skel-templates/action.php';
        }
        $contents = file_get_contents($action_template);

        if (!is_array($action_file)) {
            $action_file = array($action_file);
        }

        for ($i=0; $i<count($action_file); $i++) {
            if (!preg_match('/^(\\\\|\/)/', $action_file[$i])) {
                $action_file[$i] = '/' . $action_file[$i];
            }
            $file = substr($action_file[$i], 1);
            if (substr($file, -4) == '.php') {
                $file = substr($file, 0, -4);
            } else {
                $action_file[$i] .= '.php';
            }

            // 饹̾Ѵ
            $class_name = implode('_', array_map('ucfirst', preg_split('/(\\\\|\/)/', $file)));
            $contents_tmp = str_replace('{SYL_CLASS}', $class_name, $contents);

            $file = $action_dir . $action_file[$i];
            $tmp = dirname($file) . '/';
            $create_dir = array();
            while (preg_match('/^' . preg_quote($action_dir, '/') . '/', $tmp)) {
                array_unshift($create_dir, $tmp);
                $tmp = dirname($tmp);
            }

            foreach ($create_dir as $dir) {
                if (!is_dir($dir)) {
                    echo "  creating directory {$dir}\n"; ob_flush();
                    mkdir($dir, 0755);
                }
            }

            echo "  creating file {$file}\n"; ob_flush();
            $fp = fopen($file, 'wb');
            fwrite($fp, $contents_tmp);
            fclose($fp);
        }
    }
}

?>
