<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJson.php,v 1.1 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Jsonӥ塼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJson.php,v 1.1 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewJson extends SyL_View
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewJson(&$dm)
    {
        parent::SyL_View($dm);
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        $content_type = '';
        $javascript   = '';
        if ($this->dm->getActionName() != '') {
            // ѥ᡼ϡJson֥Ȥ򥻥å
            if (!function_exists('json_encode')) {
                include_once SYL_INCLUDE_DIR . '/lib/SyL_Json.php';
            }
            $content_type = 'application/json; charset=' . SYL_ENCODE_AJAX;
            $values     =& $this->getActionValues();
            $javascript = json_encode($values);
            $javascript = mb_convert_encoding($javascript, SYL_ENCODE_AJAX, SYL_ENCODE_INTERNAL);
        } else {
            $content_type = 'application/x-javascript; charset=' . SYL_ENCODE_INTERNAL;
            include_once SYL_INCLUDE_DIR . '/lib/SyL_AjaxJs.php';
            $ajaxjs =& new SyL_AjaxJs();
            $ajaxjs->setUrl($_SERVER['PHP_SELF']);
            $ajaxjs->setActionKey(SYL_ACTION_KEY);
            $javascript = $ajaxjs->getJs();
        }

        // JavaScirptƥĥ
        SyL_Response::setHeader('Content-Type', $content_type);
        // JavaScirpt
        $this->setRender($javascript);
    }
}

?>
