/*
 *  posdialog.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>
#include <stdio.h>

#include "posdialog.h"
#include "cannadic.h"
#include "charset.h"
#include "intl.h"

enum {
    COLUMN_ID,
    COLUMN_POS,
    COLUMN_EXAMPLE,
    N_COLUMNS_POS,
};

gchar *cannadic_pos_dialog(gint pos_type, gint system) {
    GtkWidget *dialog;
    GtkWidget *scrollwin_pos;
    GtkWidget *treeview_pos;

    GtkTreeViewColumn *column;
    GtkListStore *store;
    GtkTreeSelection *selection;
    GtkCellRenderer *renderer;
    GtkTreeIter iter;
    gint id, result;
    gchar *pos_utf8 = NULL;
    category_code *code = NULL;
    gint narrow_size, i;

    /* construct dialog */
    dialog = gtk_dialog_new_with_buttons(_("Part of Speech"), NULL,
					 GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
					 GTK_STOCK_OK,
					 GTK_RESPONSE_ACCEPT,
					 GTK_STOCK_CANCEL,
					 GTK_RESPONSE_REJECT,
					 NULL);

    gtk_widget_set_size_request(GTK_WIDGET(dialog), 300, 200);

    scrollwin_pos = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin_pos),
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       scrollwin_pos,
		       TRUE, TRUE, 10);
    gtk_widget_show(scrollwin_pos);

    treeview_pos = gtk_tree_view_new();
    gtk_container_add(GTK_CONTAINER(scrollwin_pos),
		      treeview_pos);
    gtk_widget_show(treeview_pos);

    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes("ID",
						      renderer,
						      "text", COLUMN_ID,
						      NULL);
    gtk_tree_view_column_set_visible(column, FALSE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview_pos), column);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview_pos),
				      FALSE);

    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes(_("Part of Speech"),
						      renderer,
						      "text", COLUMN_POS,
						      NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview_pos), column);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview_pos),
				      TRUE);

    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes(_("Example"),
						      renderer,
						      "text", COLUMN_EXAMPLE,
						      NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview_pos), column);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview_pos),
				      TRUE);

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview_pos));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);

    store = gtk_list_store_new(N_COLUMNS_POS,
			       G_TYPE_INT,     /* ID */
			       G_TYPE_STRING,  /* POS */
			       G_TYPE_STRING); /* EXAMPLE */
    gtk_tree_view_set_model(GTK_TREE_VIEW(treeview_pos),
			    GTK_TREE_MODEL(store));

    switch(pos_type) {
    case POS_SUBSTANTIVE:
	narrow_size = sizeof(substantive_code) / sizeof(substantive_code[0]);
	code = substantive_code;
	break;
    case POS_ADVERB:
	narrow_size = sizeof(adverb_code) / sizeof(adverb_code[0]);
	code = adverb_code;
	break;
    case POS_VERB:
	narrow_size = sizeof(verb_code) / sizeof(verb_code[0]);
	code = verb_code;
	break;
    case POS_ADJECTIVE:
	narrow_size = sizeof(adjective_code) / sizeof(adjective_code[0]);
	code = adjective_code;
	break;
    case POS_ETC:
	narrow_size = sizeof(etc_code) / sizeof(etc_code[0]);
	code = etc_code;
	break;
    }

    for(i = 0; i < narrow_size; i++) {
	if(code[i].type & system) {
	    gtk_list_store_append(store, &iter);
	    gtk_list_store_set(store, &iter,
			       COLUMN_ID, i,
			       COLUMN_POS, eucjp_to_utf8(code[i].desc),
			       COLUMN_EXAMPLE, eucjp_to_utf8(code[i].example),
			       -1);
	}
    }

    result = gtk_dialog_run(GTK_DIALOG(dialog));

    switch(result) {
    case GTK_RESPONSE_ACCEPT:
	if(gtk_tree_selection_get_selected(selection, NULL, &iter)) {
	    gtk_tree_model_get(GTK_TREE_MODEL(store), &iter,
			       COLUMN_ID, &id, -1);
	    pos_utf8 = g_strdup(code[id].code);
	}
	break;
    default:
	break;
    }
    gtk_widget_destroy(dialog);

    return pos_utf8;
}
