/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __WORDAPPEND_PANE_H__
#define __WORDAPPEND_PANE_H__

#include <gtk/gtkhbox.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtkentry.h>
#include <gtk/gtktreeview.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtkoptionmenu.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkframe.h>

#include "word.h"

#ifdef __cplusplus
extern "C" {
#endif

#define ADDWORD_PANE_TYPE		(addword_pane_get_type())
#define ADDWORD_PANE(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ADDWORD_PANE_TYPE, AddWordPane))
#define ADDWORD_PANE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ADDWORD_PANE_TYPE, AddWordPaneClass))
#define IS_ADDWORD_PANE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ADDWORD_PANE_TYPE))
#define IS_ADDWORD_PANE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ADDWORD_PANE_TYPE)
#define IS_ADDWORD_PANE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ADDWORD_PANE_TYPE, AddWordPaneClass))

typedef struct _AddWordPane AddWordPane;
typedef struct _AddWordPaneClass AddWordPaneClass;
typedef struct _AddWordPaneInfo AddWordPaneInfo;

typedef enum {
    ADDWORDPANE_MODE_NOTHING,
    ADDWORDPANE_MODE_ANTHY,
    ADDWORDPANE_MODE_CANNA,
/*    ADDWORDPANE_MODE_PRIME, */
/*    ADDWORDPANE_MODE_ANTHYCANNA, */
/*    ADDWORDPANE_MODE_ANTHYPRIME, */
/*    ADDWORDPANE_MODE_CANNAPRIME, */
    ADDWORDPANE_MODE_ALL,
} addwordpane_mode;

struct _AddWordPane {
    GtkHBox container;

    GtkEntry *phonetic;
    GtkEntry *literal;
    GtkOptionMenu *optmenu_pos;
    GtkEntry *pos_narrow;
    GtkButton *pos_browse;
    GtkEntry *frequency;

    GtkFrame *frame_checkbutton;
    GtkCheckButton *check_anthy;
    GtkCheckButton *check_canna;
    GtkCheckButton *check_prime;

    GtkButton *add;
    GtkButton *clear;

    /* private */

    /* properties */
    addwordpane_mode mode;
};

struct _AddWordPaneClass {
    GtkHBoxClass parent_class;
};

GtkWidget *addword_pane_new	 (void);
void	  addword_pane_set_mode (AddWordPane *pane, addwordpane_mode mode);
addwordpane_mode addword_pane_get_mode (AddWordPane *pane);
#ifdef __cplusplus
}
#endif
#endif /* __WORDAPPEND_PANE_H__ */
