/*
 *  topwin.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "anthy.h"
#include "canna.h"
#include "anthycontainer.h"
#include "topwin.h"

#include "intl.h"

/* prototype */
static int cb_delete_topwindow(GtkWidget *widget, GdkEvent *event, TopWindow *topwin);
static void cb_menu_file(TopWindow *topwin, guint action, GtkWidget *widget);
static void cb_menu_help(TopWindow *topwin, guint action, GtkWidget *widget);
static void cb_menu_option_switch_imsystem(TopWindow *topwin, guint action, GtkWidget *widget);
void clean_topwindow(TopWindow *topwin);

int cb_delete_topwindow(GtkWidget *widget,
			GdkEvent *event,
			TopWindow *topwin)
{
    clean_topwindow(topwin);
    gtk_main_quit();
    return FALSE;
}

void cb_menu_file(TopWindow *topwin, guint action, GtkWidget *widget) {
    switch(action) {
    case MAIN_MENU_FILE_QUIT:
	clean_topwindow(topwin);
	gtk_main_quit();
	break;
    default:
	break;
	;
    }
}

void cb_menu_help(TopWindow *topwin, guint action, GtkWidget *widget) {
    switch(action) {
    case MAIN_MENU_HELP_ABOUT:
    default:
	break;
    }
}

void cb_menu_option_switch_imsystem(TopWindow *topwin,
				    guint action,
				    GtkWidget *widget)
{
    g_return_if_fail(topwin);

    switch(action) {
    case MAIN_MENU_OPTION_ANTHY:
	if(topwin->skkcontainer != NULL)
	    gtk_widget_hide((topwin->skkcontainer)->container);
	if(topwin->cannacontainer != NULL)
	    gtk_widget_hide((topwin->cannacontainer)->container);
	if(topwin->anthycontainer != NULL)
	    gtk_widget_show((topwin->anthycontainer)->container);
	break;
    case MAIN_MENU_OPTION_SKK:
	if(topwin->anthycontainer != NULL)
	    gtk_widget_hide((topwin->anthycontainer)->container);
	if(topwin->cannacontainer != NULL)
	    gtk_widget_hide((topwin->cannacontainer)->container);
	if(topwin->skkcontainer != NULL)
	    gtk_widget_show((topwin->skkcontainer)->container);
	break;
    case MAIN_MENU_OPTION_CANNA:
	if(topwin->anthycontainer != NULL)
	    gtk_widget_hide((topwin->anthycontainer)->container);
	if(topwin->skkcontainer != NULL)
	    gtk_widget_hide((topwin->skkcontainer)->container);
	if(topwin->cannacontainer != NULL)
	    gtk_widget_show((topwin->cannacontainer)->container);
    default:
	break;
    }
}

int create_topwindow(TopWindow *topwin) {
    GtkWidget *vbox;
    GtkAccelGroup *accel_group;
    GtkItemFactory *main_menu_item_factory;
    GtkItemFactoryEntry menu_items[] = {
	{ N_("/_File"),	NULL, NULL,	0, "<Branch>" },
	{ N_("/File/_Quit"), "<control>Q", cb_menu_file, MAIN_MENU_FILE_QUIT, NULL },
	{ N_("/_Option"), NULL, NULL, 0, "<Branch>" },

	{ N_("/Option/_Anthy"), NULL, cb_menu_option_switch_imsystem, MAIN_MENU_OPTION_ANTHY, "<RadioItem>" },
	{ N_("/Option/_SKK"), NULL, cb_menu_option_switch_imsystem, MAIN_MENU_OPTION_SKK, "/Option/Anthy" },
	{ N_("/Option/_Canna"), NULL, cb_menu_option_switch_imsystem, MAIN_MENU_OPTION_CANNA, "/Option/Anthy" },
/*		{ N_("/Option/_PRIME"), NULL, cb_menu_option_switch_imsystem, MAIN_MENU_OPTION_PRIME, "/Option/Anthy" }, */
	{ N_("/_Help"), NULL, NULL, 0, "<Branch>" },
	{ N_("/Help/_About"), NULL, cb_menu_help, MAIN_MENU_HELP_ABOUT, NULL }
    };

    gint menu_items_num = sizeof(menu_items) / sizeof(menu_items[0]);

    topwin->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
/*	gtk_window_set_default_size(GTK_OBJECT(win->window), 400, 200); */
    gtk_widget_set_size_request(GTK_WIDGET(topwin->window), 600, 400);

    g_signal_connect(G_OBJECT(topwin->window), "delete_event",
		     G_CALLBACK(cb_delete_topwindow), topwin);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox);
    gtk_container_add(GTK_CONTAINER(topwin->window), vbox);

    accel_group = gtk_accel_group_new();
    main_menu_item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);
    gtk_item_factory_set_translate_func(main_menu_item_factory, (GtkTranslateFunc)gettext, NULL, NULL);
    gtk_item_factory_create_items(main_menu_item_factory, menu_items_num, menu_items, topwin);
    gtk_window_add_accel_group(GTK_WINDOW(topwin->window), accel_group);
    topwin->menubar = gtk_item_factory_get_widget(main_menu_item_factory, "<main>");
    gtk_box_pack_start(GTK_BOX(vbox), topwin->menubar, FALSE, FALSE, 0);
    gtk_widget_show(topwin->menubar);

    if(anthydic_init() == 0) {
	topwin->anthycontainer = g_malloc(sizeof(AnthyContainer));
	if(topwin->anthycontainer != NULL) {
	    create_anthycontainer(topwin->anthycontainer);
	    gtk_box_pack_start(GTK_BOX(vbox),
			       (topwin->anthycontainer)->container,
			       TRUE, TRUE, 0);
	}
    } else {
	topwin->anthycontainer = NULL;
    }

    topwin->skkcontainer = g_malloc(sizeof(SKKContainer));
    if(topwin->skkcontainer != NULL) {
	create_skkcontainer(topwin->skkcontainer);
	gtk_box_pack_start(GTK_BOX(vbox),
			   (topwin->skkcontainer)->container,
			   TRUE, TRUE, 0);
    }

    if(canna_init(NULL) == 0) {
	topwin->cannacontainer = g_malloc(sizeof(CannaContainer));
	if(topwin->cannacontainer != NULL) {
	    create_canna_container(topwin->cannacontainer);
	    gtk_box_pack_start(GTK_BOX(vbox),
			       (topwin->cannacontainer)->container,
			       TRUE, TRUE, 0);
	}
    } else {
	topwin->cannacontainer = NULL;
    }

    return 0;
}

int show_topwindow(TopWindow *topwin) {
    /* XXX */
    if(topwin->anthycontainer != NULL)
	show_anthycontainer(topwin->anthycontainer, TRUE);
    if(topwin->skkcontainer != NULL)
	show_skkcontainer(topwin->skkcontainer, FALSE);
    if(topwin->cannacontainer != NULL)
	show_canna_container(topwin->cannacontainer, FALSE);
    gtk_widget_show(topwin->window);
    return 0;
}

void clean_topwindow(TopWindow *topwin) {
    g_return_if_fail(topwin);
    g_return_if_fail(topwin->anthycontainer);
    clean_anthycontainer(topwin->anthycontainer);
}
