/*
 *  anthycontainer.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "anthycontainer.h"

#include "intl.h"

void create_anthycontainer(AnthyContainer *container) {
    GtkWidget *label_viewword, *label_addword, *label_importword;

    container->container = gtk_notebook_new();
    container->addwordpane = g_malloc(sizeof(AnthyAddWordPane));
    container->viewwordpane = g_malloc(sizeof(AnthyViewWordPane));
    container->importwordpane = g_malloc(sizeof(AnthyImportWordPane));
    create_viewwordpane(container->viewwordpane);
    create_addwordpane(container->addwordpane);
    create_anthy_importwordpane(container->importwordpane);

    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(container->container), GTK_POS_TOP);
    gtk_container_set_border_width(GTK_CONTAINER(container->container), 10);
    gtk_container_add(GTK_CONTAINER(container->container), (container->viewwordpane)->pane);

    label_viewword = gtk_label_new(_("View word"));
    gtk_widget_show(label_viewword);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(container->container),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(container->container), 0),
			       label_viewword);

    gtk_container_add(GTK_CONTAINER(container->container), (container->addwordpane)->pane);
    label_addword = gtk_label_new(_("Add word"));
    gtk_widget_show(label_addword);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(container->container),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(container->container), 1),
			       label_addword);

    gtk_container_add(GTK_CONTAINER(container->container), (container->importwordpane)->pane);
    label_importword = gtk_label_new(_("Import"));
    gtk_widget_show(label_importword);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(container->container),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(container->container), 2),
			       label_importword);

}

void show_anthycontainer(AnthyContainer *container, gboolean flags) {
    g_return_if_fail(container);
    g_return_if_fail(container->addwordpane);
    g_return_if_fail(container->viewwordpane);

    if(flags) {
	gtk_widget_show(container->container);
	gtk_widget_show((container->viewwordpane)->pane);
	gtk_widget_show((container->addwordpane)->pane);
	gtk_widget_show((container->importwordpane)->pane);
    }
}

void clean_anthycontainer(AnthyContainer *container) {
    g_return_if_fail(container);
    g_return_if_fail(container->addwordpane);
    g_return_if_fail(container->viewwordpane);

    g_free(container->addwordpane);
    g_free(container->viewwordpane);
}
