/*
   video library - provides a few functions for mode 4 and 13h programming.

   Copyright (C) 2014-2015, Mateusz Viste
   All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef video_h_sentinel

  #define video_h_sentinel

  #define VIDEO_DBUF 1

  struct video_handler {
    unsigned char *dbuf;
    unsigned char lastmode;
    int flags;
    int mode;
  };

  /* returns 0 if no VGA has been detected, non-zero otherwise */
  int video_detectvga(void);

  /* init video mode. either 0x04 for CGA or 0x13 for VGA */
  struct video_handler *video_open(int mode, int flags);

  /* reads a screen dump from file and puts it to the screen buffer */
  void video_file2screen(struct video_handler *handler, char *file);

  /* load count colors of palette from array of rgb triplets */
  void video_loadpal(unsigned char *pal, int count, int offset);

  /* load a palette from a file of RGB triplets */
  void video_loadpalfromfile(char *file, long filepos, int count, int offset);

  /* Wait until VBLANK */
  void video_waitvblank(void);

  void video_flip(struct video_handler *handler);

  /* copies line ysrc over ydst in CGA mode memory */
  void video_cgalinecopy(struct video_handler *handler, int ydst, int ysrc);

  /* clear screen using color */
  void video_cls(struct video_handler *handler, unsigned char color);

  /* renders a sprite of width and height dimensions onscreen, starting at specified x/y location
     coloffset is an offset to add to color indexes, while transp is the index of the transparent color (set to -1 if none) */
  void video_putsprite(struct video_handler *handler, unsigned char *sprite, int x, int y, int width, int height, int coloffset, int transp, int maxcol);

  /* same as video_putsprite(), but reads the sprite from a file */
  void video_putspritefromfile(struct video_handler *handler, char *file, long foffset, int x, int y, int width, int height, int coloffset, int transp, int maxcol);

  void video_close(struct video_handler *handler);

  void video_rputpixel(struct video_handler *handler, int x, int y, unsigned char col, int repeat);

  /* render a horizontal line of length len starting at x/y */
  void video_hline(struct video_handler *handler, int x, int y, int len, unsigned char color);

  /* render a vertical line of length len starting at x/y */
  void video_vline(struct video_handler *handler, int x, int y, int len, unsigned char color);

  void video_rect(struct video_handler *handler, int x, int y, int width, int height, unsigned char color);

  /* renders a rectangle on screen, at position x/y, filled with color */
  void video_rectfill(struct video_handler *handler, int x, int y, int width, int height, unsigned char color);

  void video_setpalette(int index, unsigned char r, unsigned char g, unsigned char b);

#endif
