#ifndef _CONFIG_H
#define _CONFIG_H

#if defined (__DJGPP__)
 #include "tcp_djgp.h"
#elif defined (__TURBOC__)
 #include "tcp.h"
#endif

typedef void (*SendFuncPtr)(unsigned char *, unsigned short);

#define MAX_PASSWORD_LENGTH 30

/* Configuration options */
typedef struct {
	char *username;
	char *password;
	char *remotehost;
	char *term;
	char *KeyMapFile;
	char *identity;
	unsigned short RemotePort;
	unsigned short keepalives;
	unsigned short statusline;
	unsigned short CipherType;
	tcp_Socket s;
	FILE *debugfile;
	FILE *logfile;
	FILE *brailab;
} Config;

/* Configuration options stored in bits */
#define CIPHER_ENABLED		1
#define PRESERVE_ATTRIBUTES	2
#define RECURSIVE_COPY		4
#define VERBOSE_MODE		8
#define QUIET_MODE		16
#define COMPRESSION_REQUESTED	32
#define COMPRESSION_ENABLED	64
#define NONPRIVILEGED_PORT	128
#define NEWLINE			256
#define CONVERT_LOWERCASE	512

#endif
