;-------------------------------------------------------------------------------
; Hier sind die eigentlichen Ziele. Es wurde eine Normalform fuer Ziele
; verwendet, und zwar: ($$$<Name> <Argument1>)
;-------------------------------------------------------------------------------




;-------------------------------------------------------------------------------
; Direkt den Spielerzug beantworten
;-------------------------------------------------------------------------------
(defun $$$spielerkette (dummy)
   (dolist (x muster-kontextbezogen nil)
      (if (and (> spielerkette -1) (eql (cadr x) spielerkette))
          (ziel-einplanen (list '$$$kontextbezogen (cadr x)) 100)
      )
   )
)


;-------------------------------------------------------------------------------
; Computer-Ketten sind zu retten, feindliche zu toeten
;-------------------------------------------------------------------------------
(defun $$$kette-behandeln (x)
   (if (eql 1 (!color x))
       (ziel-einplanen (list '$$$retten x) globaler-zielwert)
   )

   (if (eql -1 (!color x))
       (ziel-einplanen (list '$$$toeten x) globaler-zielwert)
   )
)


;-------------------------------------------------------------------------------
; Falls ueberhaupt kein normales Ziel gefunden wurde, dann diese ausfuehren
;-------------------------------------------------------------------------------
(defun $$$default-action (a)
   (outmsg "Default Action")
)


;-------------------------------------------------------------------------------
; Verzichten
;-------------------------------------------------------------------------------
(defun $$$aussetzen (dummy)
   (outmsg "Aussetzen")
   (setq *endeflag* t)
)



;-------------------------------------------------------------------------------
; Einen bestimmten Punkt auf dem Spielfeld zum Besetzen vorschlagen
;-------------------------------------------------------------------------------
(defun $$$besetzen (x)
   (if (!sinnvoll x)
       (Zugvorschlag x)
   )
)


;-------------------------------------------------------------------------------
; Einen lokalen Punkt zum Besetzen vorschlagen
;-------------------------------------------------------------------------------
(defun $$$lokalpunkt (x)
   (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
)





;-------------------------------------------------------------------------------
; Einen Zug mit fest vorgegebenen Wert aus Muster-Vorschlaege vorschlagen
;-------------------------------------------------------------------------------
(defun $$$festwert (x)
   (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
)

;-------------------------------------------------------------------------------
; Auf einem bestimmten Punkt eine Gruppe mit einer Treppe fangen
;-------------------------------------------------------------------------------
(defun $$$treppe-starten (x)
   (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
)

;-------------------------------------------------------------------------------
; Irgendeine Kette verstaerken
;-------------------------------------------------------------------------------
(defun $$$irgendeine-kette-behandeln (dummy)
  ;-------------------------------------------------------
  ; Alle zu schwachen Gruppen staerken
  ;-------------------------------------------------------
  (let (staerke)
       (dolist (x (!ketten) nil)
          (setq staerke (!strength x))
          (if (< staerke 4)
              (if (eql (!color x) 1)
                  (ziel-einplanen (list '$$$verstaerken x) globaler-zielwert)
              )
          )
       )
  )
)


;-------------------------------------------------------------------------------
; Eine schwache Kette verstaerken
;-------------------------------------------------------------------------------
(defun $$$verstaerken (x)
    (dolist (y muster-formzug nil)
        (if (eql (car y) x)
            (ziel-einplanen (list '$$$formzug x) globaler-zielwert)
        )
    )
    (dolist (y muster-kontextbezogen nil)
        (if (eql (cadr y) x)
            (ziel-einplanen (list '$$$kontextbezogen x) globaler-zielwert)
        )
    )
)



;-------------------------------------------------------------------------------
; Eine Kette mit einer Freiheit zu toeten versuchen
;-------------------------------------------------------------------------------
(defun $$$toeten (x)
   ;-------------------------------------------
   ; Benachbarte, eigene Gruppen sind zu retten
   ;-------------------------------------------
   (dolist (y muster-feinde nil)
      (if (and (eql (car y) x) (member (cadr y) schwache-gruppen))
          (ziel-einplanen (list '$$$retten (cadr y)) globaler-zielwert)
      )
   )

   ;--- Die Gruppe abschneiden ---
   (dolist (y muster-schneiden nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$schneiden x) globaler-zielwert)
      )
   )



   ;--- Die Gruppe abzuschneiden drohen ---
   (dolist (y muster-schnitt-drohen nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$schnitt-drohen x) globaler-zielwert)
      )
   )

   ;---------------------------------------------------
   ; Falls nur eine einzige Freiheit, dann rausschlagen
   ;---------------------------------------------------
   (let ((temp (!liberties x)))
        (if (and (eql 1 (length temp))  (!sinnvoll (car temp)))
            (ziel-einplanen (list '$$$rausschlagen x) globaler-zielwert)
        )
   )

   ;-----------------------------------------------------------------
   ; Falls drei Freiheiten, dann evtl. beruehren, um Treppe zu drohen
   ;-----------------------------------------------------------------
   (let ((temp (!liberties x)))
        (if (eql 3 (length temp))
            (dolist (y temp nil)
               (if (treppendroher y x)
                   (ziel-einplanen (list '$$$treppendroher y) globaler-zielwert)
               )
            )
        )
   )

   ;-------------------------------------------------
   ; Falls trepp-fangbar, dann atarisieren
   ;-------------------------------------------------
   (if (assoc x treppen)
       (ziel-einplanen (list '$$$trepp-fangen x) globaler-zielwert)
   )


;  ;-------------------------------------------------
;  ; Falls <= 3 Freiheiten , dann Freiheit nehmen
;  ;-------------------------------------------------
;  (if (< (length (!liberties x)) 4)
;     (ziel-einplanen (list '$$$freiheit-nehmen x) globaler-zielwert)
;  )

   ;-------------------------------------------------
   ; Alle Vorschlaege aus Muster-Kontextbezogen holen
   ;-------------------------------------------------
   (dolist (y muster-Kontextbezogen nil)
      (if (eql x (cadr y))
          (ziel-einplanen (list '$$$kontextbezogen (cadr y)) globaler-zielwert)
      )
   )

   ;-------------------------------------------------
   ; Hane-Zuege einplanen
   ;-------------------------------------------------
   (dolist (y muster-hane nil)
      (if (eql x (car y))
          (ziel-einplanen (list '$$$hane (car y)) globaler-zielwert)
      )
   )


   ;-------------------------------------------------
   ; Gegnerische Gruppe einschliessen
   ;-------------------------------------------------
   (dolist (y muster-abdichten nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$abdichten x) globaler-zielwert)
      )
   )
)


;-------------------------------------------------------------------------------
; Eine Kette zu retten versuchen
;-------------------------------------------------------------------------------
(defun $$$retten (x)
   ;-----------------------------------------------
   ; Benachbarte, feindliche Gruppen sind zu toeten
   ;-----------------------------------------------
   (dolist (y muster-feinde nil)
      (if (and (eql (car y) x) (member (cadr y) schwache-gruppen))
          (ziel-einplanen (list '$$$toeten (cadr y)) globaler-zielwert)
      )
   )

   ;-----------------------------------------------
   ; Ein Atari des Gegners verhindern
   ;-----------------------------------------------
   (if (eql 2 (length (!liberties x)))
       (ziel-einplanen (list '$$$atari-verhindern x) globaler-zielwert)
   )

   ;-------------------------------------------------
   ; Verhindern, dass der Gegner eindringt
   ;-------------------------------------------------
   (dolist (y muster-abdichten nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$abdichten x) globaler-zielwert)
      )
   )

   ;-------------------------------------------------
   ; Versuchen, zu fliehen
   ;-------------------------------------------------
   (dolist (y muster-fluchtsprung nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$fluchtsprung x) globaler-zielwert)
      )
   )

   ;-------------------------------------------------
   ; Versuchen, eine Basis zu machen
   ;-------------------------------------------------
   (dolist (y muster-Lebensvorhand nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$lebensvorhand x) globaler-zielwert)
      )
   )

   ;-----------------------------------------------
   ; Bei atarisierter Kette: Fluchtzug versuchen
   ;-----------------------------------------------
   (if (eql 1 (length (!liberties x)))
       (ziel-einplanen (list '$$$schlagen-verhindern x) globaler-zielwert)
   )

   ;--- Ein zustzliches Auge machen -------
;   (ziel-einplanen (list '$$$auge-machen x) globaler-zielwert)

   ;--- Einen Formzug versuchen ---
   (dolist (y muster-formzug nil)
       (if (eql (car y) x)
           (ziel-einplanen (list '$$$formzug x) globaler-zielwert)
       )
   )


   ;-------------------------------------------------
   ; Alle Vorschlaege aus Muster-Kontextbezogen holen
   ;-------------------------------------------------
   (dolist (y muster-Kontextbezogen nil)
      (if (eql x (cadr y))
          (ziel-einplanen (list '$$$kontextbezogen (cadr y)) globaler-zielwert)
      )
   )

   ;-------------------------------------------------
   ; Gruppe retten durch festes Verbinden
   ;-------------------------------------------------
   (dolist (y muster-fest-verbinden nil)
      (if (eql x (car y))
          (dolist (z muster-fest-verbinden nil)
              (if (and
                       (eql (cadr y) (cadr z))
                       (not (eql x (car z)))
                       (not (member (car z) (!connected x (!blackconnected))))
                  )
                  (ziel-einplanen (list '$$$fest-verbinden x) globaler-zielwert)
             )
          )
      )
   )

   ;------------------------------------------------------------
   ; Gruppe retten durch Verbinden mit einer unverbundenen Kette
   ;------------------------------------------------------------
   (dolist (y muster-verbinden nil)
      (if (eql x (car y))
          (dolist (z muster-verbinden nil)
              (if (and
                       (eql (cadr y) (cadr z))
                       (not (eql x (car z)))
                       (not (member (car z) (!connected x (!blackconnected))))
                  )
                  (ziel-einplanen (list '$$$verbinden x) globaler-zielwert)
             )
          )
      )
   )


   ;-------------------------------
   ; evtl. Nachbarn atarisieren
   ;-------------------------------
   (if (> (length (!liberties x)) 1)
       (let (temp found)
          (setq temp (!neighbours x))
          (dolist (y temp nil)
             (if (eql (length (!liberties y)) 2)
                 (setq found t)
             )
          )
          (if found
              (ziel-einplanen (list '$$$nachbarn-atarisieren x) globaler-zielwert)
          )
       )
   )

   ;-------------------------------------------------------------------
   ; Eventuell Augen zu machen versuchen
   ;-------------------------------------------------------------------
   (ziel-einplanen (list '$$$augenwert-verbessern x) globaler-zielwert)
)


;-------------------------------------------------------------------------------
; Eine Methode, um ein Auge zu machen
;-------------------------------------------------------------------------------
(defun $$$auge-machen (x)
;  (let ((temp1 (!pclass "sgebiet")))
;     (if (member x temp1) ;--- Sicherheitshalber
;         (let ((temp2 (!connected x temp1)) (temp3 (!pclass "machauge")))
;            (dolist (y temp2 nil)
;               (if (and (member y temp3) (eql (!color y) 0))
;                   (ziel-einplanen (list '$$$besetzen y) globaler-zielwert)
;               )
;            )
;         )
;     )
;  )
)

;-------------------------------------------------------------------------------
; Den Augenwert einer Kette verbessern
;-------------------------------------------------------------------------------
(defun $$$augenwert-verbessern (x)
   (dolist (y (!connected x (!black-territory)) nil)
      (if (and (!legal y 1) (> (!point-liberties y) 1))
          (ziel-einplanen (list '$$$augenpunkt y) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Einen Punkt innerhalb einer Gruppe besetzen, um den Augenwert zu verbessern
;-------------------------------------------------------------------------------
(defun $$$augenpunkt (x)
   (outmsg "$$$Augenpunkt")
   (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
)

;-------------------------------------------------------------------------------
; Eine Nachbarkette einer eigenen Kette atarisieren
;-------------------------------------------------------------------------------
(defun $$$nachbarn-atarisieren (x)
   (dolist (y (!ketten) nil)
      (if (and (!touches x y)
               (eql (length (!liberties y)) 2)
          )
          (dolist (z (!liberties y) nil)
               (ziel-einplanen (list '$$$besetzen z) globaler-zielwert)
          )
      )
   )
)


;-------------------------------------------------------------------------------
; Eine Kette mit einer Treppe fangen
;-------------------------------------------------------------------------------
(defun $$$trepp-fangen (x)
   (let ((temp (cadr (assoc x treppen))))
      (if temp
          (ziel-einplanen (list '$$$treppe-starten (car temp)) globaler-zielwert)
      )
   )
)



;-------------------------------------------------------------------------------
; Eine Methode, um ein Atari zu verhindern.
;-------------------------------------------------------------------------------
(defun $$$atari-verhindern (x)
   (dolist (y (!liberties x) nil)
     (if (> (!point-liberties y) 1)
         (ziel-einplanen (list '$$$besetzen y) globaler-zielwert)
     )
   )
)



;-------------------------------------------------------------------------------
; Das Geschlagen-werden verhindern
;-------------------------------------------------------------------------------
(defun $$$schlagen-verhindern (x)
  (let ((temp (!escape-moves x)))
     (if temp
         (dolist (y temp nil)
            (ziel-einplanen (list '$$$besetzen y) globaler-zielwert)
         )
     )
  )
)


;-------------------------------------------------------------------------------
; Eine Kette rausschlagen, indem alle Freiheiten besetzt werden
;-------------------------------------------------------------------------------
(defun $$$rausschlagen (x)
   (outmsg "$$$rausschlagen")
   (let ((temp (!liberties x)))
      (dolist (y temp nil)
         (ziel-einplanen (list '$$$besetzen y) globaler-zielwert)
      )
   )
)


;-------------------------------------------------------------------------------
; Einer feindlichen Kette eine Freiheit nehmen
;-------------------------------------------------------------------------------
(defun $$$freiheit-nehmen (x)
   (outmsg "$$$Freiheit nehmen")
   (let ((temp (!liberties x)))
      (dolist (y temp nil)
         (ziel-einplanen (list '$$$besetzen y) globaler-zielwert)
      )
   )
)


;-------------------------------------------------------------------------------
; Als erster ein Eck besetzen
;-------------------------------------------------------------------------------
(defun $$$eck-besetzen (dummy)
   (outmsg "$$$eck-besetzen")
   (dolist (x Muster-Eckzuege nil)
      (ziel-einplanen (list '$$$besetzen x) (zufall globaler-zielwert))
   )
)


;-------------------------------------------------------------------------------
; Einen Formzug machen
;-------------------------------------------------------------------------------
(defun $$$formzug (x)
   (outmsg "$$$Formzug")
   (dolist (y Muster-Formzug nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) (+ globaler-zielwert (zv (cadr y))))
      )
   )
)

;-------------------------------------------------------------------------------
; Eine eigene Kette verbinden
;-------------------------------------------------------------------------------
(defun $$$verbinden (x)
   (outmsg "Ich versuche, meine Ketten zu verbinden")
   (dolist (y Muster-Verbinden nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Eine eigene Kette fest verbinden
;-------------------------------------------------------------------------------
(defun $$$fest-verbinden (x)
   (outmsg "Ich versuche, meine Ketten fest zu verbinden")
   (dolist (y Muster-Fest-Verbinden nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Eine feindliche Kette abschneiden
;-------------------------------------------------------------------------------
(defun $$$schneiden (x)
   (outmsg "$$$Schneiden")
   (dolist (y Muster-Schneiden nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Eine feindliche Kette abzuschneiden drohen
;-------------------------------------------------------------------------------
(defun $$$schnitt-drohen (x)
   (outmsg "$$$Schnitt drohen")
   (dolist (y Muster-Schnitt-drohen nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Eine eigene Gruppe gegen einen Gegner abdichten oder den Gegner einschliessen
;-------------------------------------------------------------------------------
(defun $$$abdichten (x)
   (outmsg "$$$Abdichten")
   (dolist (y Muster-Abdichten nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$abdichtpunkt (cadr y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Einen Abdichtungszug ausfuehren
;-------------------------------------------------------------------------------
(defun $$$abdichtpunkt (x)
   (outmsg "$$$Abdichtpunkt")
   (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
)

;-------------------------------------------------------------------------------
; Einen Punkt, der eine Treppe androht, ausfuehren
;-------------------------------------------------------------------------------
(defun $$$treppendroher (x)
   (outmsg "$$$Treppendroher")
   (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
)

;-------------------------------------------------------------------------------
; Einen Keima-Angriff von der 3. Reihe aus auf einen Stein der 4. Reihe
;-------------------------------------------------------------------------------
(defun $$$DreiVier (x)
   (outmsg "$$$Dreivier")
   (dolist (y Muster-DreiVier nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) (+ globaler-zielwert (zv (cadr y))))
      )
   )
)



;-------------------------------------------------------------------------------
; Eine Kette durch Fliehen zu retten versuchen
;-------------------------------------------------------------------------------
(defun $$$fluchtsprung (x)
   (outmsg "$$$Fluchtsprung")
   (dolist (y Muster-Fluchtsprung nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)



;-------------------------------------------------------------------------------
; Einen kontextbezogen vorgeschlagenen Zug machen. Als Parameter wird die
; Kette (!!!) angegeben.
;-------------------------------------------------------------------------------
(defun $$$kontextbezogen (kette)
   (outmsg "Kontextbezogener Zug")
   (dolist (y muster-kontextbezogen nil)
      (if (eql (cadr y) kette)
         (ziel-einplanen (list '$$$kontextbezogen-setzen (car y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Einen Stein setzen, der kontextbezogen vorgeschlagen wurde
;-------------------------------------------------------------------------------
(defun $$$kontextbezogen-setzen (ort)
   (outmsg "Kontextbezogen vorgeschlagenen Stein setzen")
   (ziel-einplanen (list '$$$besetzen ort) globaler-zielwert)
)


;-------------------------------------------------------------------------------
; Einen Zug am Rand auf der 3. oder 4. Reihe machen
;-------------------------------------------------------------------------------
(defun $$$rand-besetzen (dummy)
   (outmsg "$$$rand-besetzen")
   (dolist (x Muster-Randzuege nil)
      (ziel-einplanen (list '$$$besetzen x) globaler-zielwert)
   )
)


;-------------------------------------------------------------------------------
; Einen Sicherungszug machen, um einer Invasion vorzubeugen
;-------------------------------------------------------------------------------
(defun $$$invasion-verhindern (dummy)
   (outmsg "Ich will eine Invasion verhindern")
   (dolist (x Muster-Invasion-Verhindern nil)
      (ziel-einplanen (list '$$$besetzen x) (+ globaler-zielwert (zv x)))
   )
)


;-------------------------------------------------------------------------------
; Irgendeinen kontextfreien Abdichtungszug machen
;-------------------------------------------------------------------------------
(defun $$$irgendeine-abdichtung (dummy)
   (outmsg "Ich berlege mir irgendeinen Abdichtungszug")
   (dolist (x Muster-Abdichten nil)
      (ziel-einplanen (list '$$$besetzen (cadr x)) (+ globaler-zielwert (zv (cadr x))))
   )
)

;-------------------------------------------------------------------------------
; Bei irgendeiner Kette eine Basis erzeugen
;-------------------------------------------------------------------------------
(defun $$$irgendeine-Basis (dummy)
   (outmsg "Ich berlege mir irgendeine Basis-Ausdehnung")
   (dolist (x Muster-Basiszuege nil)
      (ziel-einplanen (list '$$$besetzen (cadr x)) (+ globaler-zielwert (zv (cadr x))))
   )
)

;-------------------------------------------------------------------------------
; Einen kontextbezogenen Zug ohne Kontextbezug machen
;-------------------------------------------------------------------------------
(defun $$$irgendein-kontextzug (dummy)
   (outmsg "Ich plane irgendeinen empfohlenen Zug")
   (dolist (x Muster-Kontextbezogen nil)
      (ziel-einplanen (list '$$$besetzen (car x)) (+ globaler-zielwert (zv (car x))))
   )
)

;-------------------------------------------------------------------------------
; Irgendeinen kontextfreien Formzug machen
;-------------------------------------------------------------------------------
(defun $$$irgendein-formzug (dummy)
   (outmsg "Ich berlege mir irgendeinen Formzug")
   (dolist (x Muster-Formzug nil)
      (ziel-einplanen (list '$$$besetzen (cadr x)) (+ globaler-zielwert (zv (cadr x))))
   )
)

;-------------------------------------------------------------------------------
; Den gebietsmaessig "groessten" vorgeschlagenen Zug machen
;-------------------------------------------------------------------------------
(defun $$$irgendein-vorgeschlagener-zug (dummy)
   (outmsg "Ein groer Gebietszug")
   (dotimes (i 361 nil)
      (garbage-collection)
      (if (which i t)
          (ziel-einplanen (list '$$$besetzen i) (+ globaler-zielwert (zv i)))
      )
   )
)

;-------------------------------------------------------------------------------
; Einen einzelnen Stein im Eck verstrken durch einen weiteren Stein
;-------------------------------------------------------------------------------
(defun $$$shimari (dummy)
   (outmsg "$$$shimari")
   (dolist (x Muster-Shimaris nil)
      (ziel-einplanen (list '$$$shimari-punkt (cadr x)) globaler-zielwert)
   )
)


;-------------------------------------------------------------------------------
; Aufspaltung der Routine $$$shimari, um vergleiche zwischen Zuegen zu ermoegl.
;-------------------------------------------------------------------------------
(defun $$$shimari-punkt (x)
   (if (!sinnvoll x)
       (Zugvorschlag x)
   )
)





;-------------------------------------------------------------------------------
; Ein Shimari durch einen dritten Stein invasionssicher machen
;-------------------------------------------------------------------------------
(defun $$$ecktripel (dummy)
   (outmsg "$$$ecktripel")
   (dolist (x Muster-Ecktripel nil)
      (Zugvorschlag x)
   )
)




;-------------------------------------------------------------------------------
; Einen Zug machen, der in der neutralen Zone liegt
;-------------------------------------------------------------------------------
(defun $$$endspiel-neutralzug (dummy)
   (outmsg "$$$endspiel-neutralzug")
   (let (Neutrale)
      (setq Neutrale (check-empty (!neutral)))
      (garbage-collection)
      (dolist (x Neutrale nil)
         (ziel-einplanen (list '$$$lokalpunkt x) (zufall globaler-zielwert))
      )
   )
)


;-------------------------------------------------------------------------------
; Einen Zug machen, der in seiner Umgebung der Beste ist.
;-------------------------------------------------------------------------------
(defun $$$lokal-optimal (dummy)
   (outmsg "Lokal optimale Zge werden eingeplant")
   (dolist (x muster-lokal-optimal nil)
      (dotimes (y (cadr x) nil)
         (Zugvorschlag (car x))
      )
   )
)

;-------------------------------------------------------------------------------
; Ein Hane-Zug von einer eigenen Kette aus oder gegen eine feindliche Kette
;-------------------------------------------------------------------------------
(defun $$$hane (x)
   (outmsg "$$$Hane")
   (dolist (y Muster-Hane nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)

;-------------------------------------------------------------------------------
; Einigermaen mit Vorhand androhen, zu leben
;-------------------------------------------------------------------------------
(defun $$$lebensvorhand (x)
   (outmsg "$$$Lebensvorhand")
   (dolist (y Muster-Lebensvorhand nil)
      (if (eql (car y) x)
          (ziel-einplanen (list '$$$besetzen (cadr y)) globaler-zielwert)
      )
   )
)

