#!/bin/bash

# ==============================================================================
# Get the latest mozc
# ==============================================================================

rm -rf mozc_tmp/
mkdir mozc_tmp
cd mozc_tmp/

# See https://github.com/google/mozc/blob/master/doc/build_mozc_in_osx.md
git clone https://github.com/google/mozc.git -b master --single-branch --recursive --depth=1
rm -rf `find . -type d -name ".git"`
rm -f `find . -type f -name ".*"`

cd mozc/src/third_party/
rm -rf gtest/
rm -rf guava
rm -rf breakpad/
rm -rf ipa_font/
rm -rf noto_font/
rm -rf wtl/
rm -rf zlib/
cd -

cd ..
ruby generate-mozc-tarball.rb
mv mozc_tmp/mozc-*.tar.bz2 .
rm -rf mozc_tmp/
