#!/usr/bin/ruby
# -*- coding:utf-8 -*-


# ==============================================================================
# filter_entries
# ==============================================================================

filter_entries = Proc.new do
	file = File.new("filter-mozc.txt", "r")
		filt = file.read.split("\n")
	file.close

	filt.length.times do |i|
		if filt[i].index("/") == 0
			# 高速化のためあらかじめ正規表現の形にしておく
			filt[i] = /#{filt[i][1..-2]}/
		end
	end

	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		s = lines[i].chomp.split("	")

		# エントリの並びの例
		# ほとんどのこと	1884	2033	7360	殆どのこと

		filt.length.times do |c|
			if s[4].index(filt[c]) != nil
				s[4] = ""
				break
			end

			if filt[c].to_s.index("	") != nil
				t1 = filt[c].split("	")[0]
				t2 = filt[c].split("	")[1]

				if s[4].index(t1) != nil
					s[4] = s[4].sub(t1, t2)
					s[3] = s[3].to_i * 0.9
					s[3] = s[3].to_i.to_s
					dicfile.puts s.join("	")
					break
				end
			end
		end

		if s[4] != ""
			dicfile.puts lines[i]
		end
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".filt"

	filter_entries.call
end
