#!/bin/sh

rm -f SKK-JISYO.L
wget -N http://openlab.ring.gr.jp/skk/dic/SKK-JISYO.L.gz
gzip -dk SKK-JISYO.L.gz

cp skk-jisyo.hits skk-jisyo.hits_bak

ruby ../src/convert-euc-to-utf8.rb SKK-JISYO.L
ruby modify-skkdic.rb SKK-JISYO.L.utf8

ruby ../src/get-yomigana-hyouki.rb SKK-JISYO.L.utf8.modskk
ruby ../src/remove-duplicates.rb SKK-JISYO.L.utf8.modskk.pairs

cat ../src/dictionary_oss/dictionary*.txt.mozc ../*/*.hits SKK-JISYO.L.utf8.modskk.pairs.remdup > allwords
ruby ../src/apply-previous-hits.rb allwords

split -d -l $(expr $(grep '' allwords.new | wc -l) / 3 + 1) allwords.new allwords.new

ruby ../src/get-jawiki-hits.rb allwords.new00 &
ruby ../src/get-jawiki-hits.rb allwords.new01 &
ruby ../src/get-jawiki-hits.rb allwords.new02 &
wait

cat allwords.exist allwords.new*.hits > skk-jisyo.hits

rm SKK-JISYO.L.utf8*
rm allwords*
