#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'nkf'


# ==============================================================================
# generate_katakana_english
# ==============================================================================

generate_katakana_english = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		# 全角スペースで始まるエントリを飛ばす
		if lines[i][0] == "　"
			next
		end

		# 日本語と英訳に分ける
		# パスタ /(n) pasta (ita:)/(P)/EntL1101460X/
		s = lines[i].chomp.split(" /")
		yomi = s[0]
		hyouki = s[1].split("/")[0]

		# 漢字が混じるエントリを飛ばす
		# 住宅 [じゅうたく] /(n)
		if yomi.index(" [") != nil ||
		# ひらがなが混じるエントリを飛ばす
		yomi.index(/[ぁ-ゔ]/) != nil
			next
		end

		# カタカナ表記を分割
		# バイオリン(P);ヴァイオリン(P) /(n) violin/(P)/EntL1097740X/
		yomi = yomi.split(";")
		# 不要な表記を削除
		# ik	word containing irregular kana usage
		# io	irregular okurigana usage
		# ok	out-dated or obsolete kana usage
		yomi = yomi.delete_if {|s| s.index("(ik)") != nil}
		yomi = yomi.delete_if {|s| s.index("(io)") != nil}
		yomi = yomi.delete_if {|s| s.index("(ok)") != nil}
		yomi = yomi.each_index {|c| yomi[c] = yomi[c].split("(")[0]}
		# 読みの中黒を取る
		yomi = yomi.each_index {|c| yomi[c] = yomi[c].tr('・', '')}
		# 重複した読みを削除
		yomi = yomi.uniq
		# 1文字の読みを削除
		yomi = yomi.delete_if {|s| s.length < 2}
		# 読みをひらがなに変換
		yomi = yomi.each_index {|c| yomi[c] = NKF.nkf("--hiragana -w -W", yomi[c])}
		yomi = yomi.each_index {|c| yomi[c] = yomi[c].tr('ゐゑ', 'いえ')}

		# 英訳から英語表記を作る
		# 英訳の前にある {} を取る
		# パスフレーズ;パス・フレーズ /(n) {comp} pass phrase/EntL2320010X/
		if hyouki.index("} ") != nil
			hyouki = hyouki.split("} ")[1]
		end

		# 英訳の前にある () を取る
		# () は前に2個ついていたり後ろに2個ついていたりするので工夫が必要
		# アオザイ /(n) ao dai (traditional Vietnamese dress) (vie:)/EntL2186380X/
		while hyouki.index("(") == 0
			hyouki = hyouki.split(") ")[1..-1].join(") ")
		end

		# 英訳の後ろにある () を取る
		# アオザイ /(n) ao dai (traditional Vietnamese dress) (vie:)/EntL2186380X/
		hyouki = hyouki.split(" (")[0]

		# 英訳が3語以上の場合は収録しない
		if hyouki.split(" ").length > 2 ||
		# 1文字の英訳を削除
		hyouki.length < 2
			next
		end

		# 英語表記のコストを指定
		hits = 9010

		yomi.length.times do |c|
			dicfile.puts yomi[c] + "	" + hyouki + "	" + hits.to_s
			# カタカナ表記を補充
			# edict辞書で収録されているはずだが念のため
			dicfile.puts yomi[c] + "	" + NKF.nkf("--katakana -w -W", yomi[c]) + "	" + (hits - 10).to_s
			# ひらがな表記を補充
			dicfile.puts yomi[c] + "	" + yomi[c] + "	" + (hits + 10).to_s
		end
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".kanaeng"

	generate_katakana_english.call
end
