/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.instruction;

import java.util.List;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;

public class DexBackedSparseSwitchPayload
extends DexBackedInstruction
implements SparseSwitchPayload {
    public final int elementCount;

    public DexBackedSparseSwitchPayload(DexBackedDexFile dexFile, int instructionStart) {
        super(dexFile, Opcode.SPARSE_SWITCH_PAYLOAD, instructionStart);
        this.elementCount = dexFile.getDataBuffer().readUshort(instructionStart + 2);
    }

    @Override
    public List<? extends SwitchElement> getSwitchElements() {
        return new FixedSizeList<SwitchElement>(){

            @Override
            public SwitchElement readItem(final int index) {
                return new SwitchElement(){

                    @Override
                    public int getKey() {
                        return DexBackedSparseSwitchPayload.this.dexFile.getDataBuffer().readInt(DexBackedSparseSwitchPayload.this.instructionStart + 4 + index * 4);
                    }

                    @Override
                    public int getOffset() {
                        return DexBackedSparseSwitchPayload.this.dexFile.getDataBuffer().readInt(DexBackedSparseSwitchPayload.this.instructionStart + 4 + DexBackedSparseSwitchPayload.this.elementCount * 4 + index * 4);
                    }
                };
            }

            @Override
            public int size() {
                return DexBackedSparseSwitchPayload.this.elementCount;
            }
        };
    }

    @Override
    public int getCodeUnits() {
        return 2 + this.elementCount * 4;
    }
}

