/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.util.ExceptionWithContext;

public class DexBuffer {
    final byte[] buf;
    final int baseOffset;

    public DexBuffer(byte[] buf) {
        this(buf, 0);
    }

    public DexBuffer(byte[] buf, int offset) {
        this.buf = buf;
        this.baseOffset = offset;
    }

    public int readSmallUint(int offset) {
        int result;
        byte[] buf = this.buf;
        if ((result = buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24) < 0) {
            throw new ExceptionWithContext("Encountered small uint that is out of range at offset 0x%x", offset);
        }
        return result;
    }

    public int readOptionalUint(int offset) {
        int result;
        byte[] buf = this.buf;
        if ((result = buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24) < -1) {
            throw new ExceptionWithContext("Encountered optional uint that is out of range at offset 0x%x", offset);
        }
        return result;
    }

    public int readUshort(int offset) {
        byte[] buf = this.buf;
        return buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    public int readUbyte(int offset) {
        return this.buf[offset + this.baseOffset] & 0xFF;
    }

    public long readLong(int offset) {
        byte[] buf = this.buf;
        return (long)(buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16) | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 6] & 0xFFL) << 48 | (long)buf[offset + 7] << 56;
    }

    public int readLongAsSmallUint(int offset) {
        long result;
        byte[] buf = this.buf;
        if ((result = (long)(buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16) | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 6] & 0xFFL) << 48 | (long)buf[offset + 7] << 56) < 0L || result > Integer.MAX_VALUE) {
            throw new ExceptionWithContext("Encountered out-of-range ulong at offset 0x%x", offset);
        }
        return (int)result;
    }

    public int readInt(int offset) {
        byte[] buf = this.buf;
        return buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
    }

    public int readShort(int offset) {
        byte[] buf = this.buf;
        return buf[offset += this.baseOffset] & 0xFF | buf[offset + 1] << 8;
    }

    public int readByte(int offset) {
        return this.buf[this.baseOffset + offset];
    }

    public DexReader<? extends DexBuffer> readerAt(int offset) {
        return new DexReader<DexBuffer>(this, offset);
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }
}

