/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import org.jf.dexlib2.HiddenApiRestriction;
import org.jf.dexlib2.base.reference.BaseFieldReference;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import org.jf.dexlib2.dexbacked.util.EncodedArrayItemIterator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;

public class DexBackedField
extends BaseFieldReference
implements Field {
    public final DexBackedDexFile dexFile;
    public final ClassDef classDef;
    public final int accessFlags;
    public final EncodedValue initialValue;
    public final int annotationSetOffset;
    public final int fieldIndex;
    private final int startOffset;
    private final int initialValueOffset;
    private final int hiddenApiRestrictions;
    private int fieldIdItemOffset;

    public DexBackedField(DexBackedDexFile dexFile, DexReader reader, DexBackedClassDef classDef, int previousFieldIndex, EncodedArrayItemIterator staticInitialValueIterator, AnnotationsDirectory.AnnotationIterator annotationIterator, int hiddenApiRestrictions) {
        this.dexFile = dexFile;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = staticInitialValueIterator.getReaderOffset();
        this.initialValue = staticInitialValueIterator.getNextOrNull();
        this.hiddenApiRestrictions = hiddenApiRestrictions;
    }

    public DexBackedField(DexBackedDexFile dexFile, DexReader reader, DexBackedClassDef classDef, int previousFieldIndex, AnnotationsDirectory.AnnotationIterator annotationIterator, int hiddenApiRestrictions) {
        this.dexFile = dexFile;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = 0;
        this.initialValue = null;
        this.hiddenApiRestrictions = hiddenApiRestrictions;
    }

    @Override
    public String getName() {
        return (String)this.dexFile.getStringSection().get(this.dexFile.getBuffer().readSmallUint(this.getFieldIdItemOffset() + 4));
    }

    @Override
    public String getType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readUshort(this.getFieldIdItemOffset() + 2));
    }

    @Override
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.annotationSetOffset);
    }

    @Override
    public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
        if (this.hiddenApiRestrictions == 7) {
            return ImmutableSet.of();
        }
        return EnumSet.copyOf(HiddenApiRestriction.getAllFlags(this.hiddenApiRestrictions));
    }

    public static void skipFields(DexReader reader, int count) {
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }

    private int getFieldIdItemOffset() {
        if (this.fieldIdItemOffset == 0) {
            this.fieldIdItemOffset = this.dexFile.getFieldSection().getOffset(this.fieldIndex);
        }
        return this.fieldIdItemOffset;
    }
}

