/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import utilities.ExecRunner;
import utilities.ProgressBarOutputStreamCR;
import utilities.ProgressStatusWorker;

public class PackageDatabase
extends ExecRunner {
    private String rootDirectory;

    public PackageDatabase(String rootDir, ProgressStatusWorker progressStatus) {
        super(new ProgressBarOutputStreamCR(progressStatus.getProgressBar()));
        this.rootDirectory = rootDir;
        this.createGetPackageDBCommand();
    }

    private void createGetPackageDBCommand() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add("/usr/bin/pacman");
        if (!this.rootDirectory.isEmpty()) {
            commandArgs.add("-r");
            commandArgs.add(this.rootDirectory);
        }
        commandArgs.add("-Q");
        this.addExecCommand(commandArgs);
    }

    public HashMap<String, String> getPackageDatabase() {
        this.execCommands();
        HashMap<String, String> pkgDB = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getOutputStream().toString(), "\n");
        while (stringTokenizer.hasMoreElements()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextElement().toString(), " ");
            while (stringTokenizer2.hasMoreElements()) {
                String pkgName = stringTokenizer2.nextElement().toString();
                String pkgVers = stringTokenizer2.nextElement().toString();
                pkgDB.put(pkgName, pkgVers);
            }
        }
        return pkgDB;
    }
}

