/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;

public class LocalHistory {
    protected JSVGViewerFrame svgFrame;
    protected JMenu menu;
    protected int index;
    protected List visitedURIs = new ArrayList();
    protected int currentURI = -1;
    protected ButtonGroup group = new ButtonGroup();
    protected ActionListener actionListener = new RadioListener();
    protected int state;
    protected static final int STABLE_STATE = 0;
    protected static final int BACK_PENDING_STATE = 1;
    protected static final int FORWARD_PENDING_STATE = 2;
    protected static final int RELOAD_PENDING_STATE = 3;

    public LocalHistory(JMenuBar mb, JSVGViewerFrame svgFrame) {
        this.svgFrame = svgFrame;
        int mc = mb.getMenuCount();
        int i = 0;
        while (i < mc) {
            JMenu m = mb.getMenu(i);
            int ic = m.getItemCount();
            int j = 0;
            while (j < ic) {
                String s;
                JMenuItem mi = m.getItem(j);
                if (mi != null && "@@@".equals(s = mi.getText())) {
                    this.menu = m;
                    this.index = j;
                    m.remove(j);
                    return;
                }
                ++j;
            }
            ++i;
        }
        throw new IllegalArgumentException("No '@@@' marker found");
    }

    public void back() {
        this.update();
        this.state = 1;
        this.currentURI -= 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoBack() {
        return this.currentURI > 0;
    }

    public void forward() {
        this.update();
        this.state = 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoForward() {
        return this.currentURI < this.visitedURIs.size() - 1;
    }

    public void reload() {
        this.update();
        this.state = 3;
        --this.currentURI;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public void update(String uri) {
        JMenuItem mi;
        JMenuItem mi2;
        int i;
        if (this.currentURI < -1) {
            throw new IllegalStateException("Unexpected currentURI:" + this.currentURI);
        }
        this.state = 0;
        if (++this.currentURI < this.visitedURIs.size()) {
            if (!this.visitedURIs.get(this.currentURI).equals(uri)) {
                int len = this.menu.getItemCount();
                i = len - 1;
                while (i >= this.index + this.currentURI + 1) {
                    mi2 = this.menu.getItem(i);
                    this.group.remove(mi2);
                    this.menu.remove(i);
                    --i;
                }
                this.visitedURIs = this.visitedURIs.subList(0, this.currentURI + 1);
            }
            mi = this.menu.getItem(this.index + this.currentURI);
            this.group.remove(mi);
            this.menu.remove(this.index + this.currentURI);
            this.visitedURIs.set(this.currentURI, uri);
        } else {
            if (this.visitedURIs.size() >= 15) {
                this.visitedURIs.remove(0);
                mi = this.menu.getItem(this.index);
                this.group.remove(mi);
                this.menu.remove(this.index);
                --this.currentURI;
            }
            this.visitedURIs.add(uri);
        }
        String text = uri;
        i = uri.lastIndexOf(47);
        if (i == -1) {
            i = uri.lastIndexOf(92);
        }
        if (i != -1) {
            text = uri.substring(i + 1);
        }
        mi2 = new JRadioButtonMenuItem(text);
        mi2.setToolTipText(uri);
        mi2.setActionCommand(uri);
        mi2.addActionListener(this.actionListener);
        this.group.add(mi2);
        mi2.setSelected(true);
        this.menu.insert(mi2, this.index + this.currentURI);
    }

    protected void update() {
        switch (this.state) {
            case 1: {
                this.currentURI += 2;
                break;
            }
            case 3: {
                ++this.currentURI;
                break;
            }
        }
    }

    protected class RadioListener
    implements ActionListener {
        protected RadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String uri = e.getActionCommand();
            LocalHistory.this.currentURI = this.getItemIndex((JMenuItem)e.getSource()) - 1;
            LocalHistory.this.svgFrame.showSVGDocument(uri);
        }

        public int getItemIndex(JMenuItem item) {
            int ic = LocalHistory.this.menu.getItemCount();
            int i = LocalHistory.this.index;
            while (i < ic) {
                if (LocalHistory.this.menu.getItem(i) == item) {
                    return i - LocalHistory.this.index;
                }
                ++i;
            }
            throw new IllegalArgumentException("MenuItem is not from my menu!");
        }
    }
}

