/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.image.AcmeGifFormatter;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.j3d.OM3DConstants;
import com.bbn.openmap.tools.j3d.OM3DGraphicHandler;
import com.bbn.openmap.tools.j3d.OMGraphicUtil;
import com.bbn.openmap.util.Debug;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;

public class MapContent
extends BranchGroup
implements OM3DConstants {
    protected MapBean map;
    protected Proj proj;
    protected LayerHandler layerHandler;
    protected HashSet graphicHandlers;
    protected MapHandler mapHandler;

    public MapContent(MapHandler mapHandler, int contentMask) {
        this.init(mapHandler);
        if ((contentMask & 2) != 0) {
            this.createMapObjects();
        }
        if ((contentMask & 4) != 0) {
            this.createMapImage();
        }
        if ((contentMask & 8) != 0) {
            this.createMapElevations();
        }
    }

    protected void init(MapHandler mapHandler) {
        if (mapHandler == null) {
            return;
        }
        this.map = (MapBean)mapHandler.get("com.bbn.openmap.MapBean");
        this.proj = null;
        if (this.map != null) {
            this.proj = (Proj)this.map.getProjection();
        }
        this.mapHandler = mapHandler;
    }

    protected HashSet getGraphicHandlers(MapHandler mapHandler) {
        Debug.message((String)"3d", (String)"LayerMapContent: looking for OM3DGraphicHandlers.");
        HashSet ret = new HashSet();
        for (Object obj : mapHandler) {
            if (!(obj instanceof OM3DGraphicHandler)) continue;
            Debug.message((String)"3d", (String)("LayerMapContent: found one, adding " + obj));
            ret.add(obj);
        }
        this.layerHandler = (LayerHandler)mapHandler.get("com.bbn.openmap.LayerHandler");
        if (this.layerHandler != null) {
            Layer[] layers = this.layerHandler.getLayers();
            int size = layers.length;
            for (int i = size - 1; i >= 0; --i) {
                Layer layer = layers[i];
                if (!layer.isVisible() || !(layer instanceof OM3DGraphicHandler)) continue;
                Debug.message((String)"3d", (String)("LayerMapContent: found layer version, adding " + layer.getName()));
                ret.add(layer);
            }
        }
        return ret;
    }

    public Projection getProjection() {
        return this.proj;
    }

    protected void createMapObjects() {
        if (this.mapHandler == null) {
            Debug.error((String)"MapContent: MapHandler not set!");
            return;
        }
        this.graphicHandlers = this.getGraphicHandlers(this.mapHandler);
        Iterator iterator = this.graphicHandlers.iterator();
        while (iterator.hasNext()) {
            ((OM3DGraphicHandler)iterator.next()).addGraphicsToScene(this);
        }
    }

    public void add(OMGrid grid) {
        this.add(OMGraphicUtil.createShape3D(grid, 0.0, (Projection)this.proj));
    }

    public void add(OMGraphic omgraphic, double height) {
        this.add(OMGraphicUtil.createShape3D(omgraphic, height));
    }

    public void add(Shape3D shape) {
        this.addChild((Node)shape);
    }

    protected void add(Iterator shapeIterator) {
        while (shapeIterator.hasNext()) {
            try {
                Shape3D shape = (Shape3D)shapeIterator.next();
                if (shape == null) continue;
                this.add(shape);
            }
            catch (ClassCastException cce) {}
        }
    }

    protected void add(TransformGroup transformGroup) {
        this.addChild((Node)transformGroup);
    }

    protected void createMapElevations() {
        Debug.error((String)"MapContent.createMapElevations not implemented.");
    }

    protected void createMapImage() {
        if (this.proj == null || this.mapHandler == null) {
            Debug.error((String)"MapContent: MapHandler not set!");
            return;
        }
        int pwidth = 512;
        int pheight = 512;
        AcmeGifFormatter formatter = new AcmeGifFormatter();
        Graphics graphics = formatter.getGraphics(pwidth, pheight);
        Paint background = this.map == null ? MapBean.DEFAULT_BACKGROUND_COLOR : this.map.getBckgrnd();
        this.proj.drawBackground((Graphics2D)graphics, background);
        this.layerHandler = (LayerHandler)this.mapHandler.get("com.bbn.openmap.LayerHandler");
        if (this.layerHandler != null) {
            Debug.message((String)"3d", (String)"LayerMapContent: putting layer graphics on the map.");
            Layer[] layers = this.layerHandler.getLayers();
            int size = layers.length;
            for (int i = size - 1; i >= 0; --i) {
                Layer layer = layers[i];
                if (!layer.isVisible() || layer instanceof OM3DGraphicHandler) continue;
                layer.renderDataForProjection((Projection)this.proj, graphics);
            }
        }
        BufferedImage bimage = formatter.getBufferedImage();
        QuadArray plane = new QuadArray(4, 33);
        float height = pheight;
        float width = pwidth;
        Point3f p = new Point3f(0.0f, 0.0f, 0.0f);
        plane.setCoordinate(0, p);
        p.set(0.0f, 0.0f, height);
        plane.setCoordinate(1, p);
        p.set(width, 0.0f, height);
        plane.setCoordinate(2, p);
        p.set(0.0f, 0.0f, height);
        plane.setCoordinate(3, p);
        Point2f q = new Point2f(0.0f, 1.0f);
        plane.setTextureCoordinate(0, q);
        q.set(0.0f, 0.0f);
        plane.setTextureCoordinate(1, q);
        q.set(1.0f, 0.0f);
        plane.setTextureCoordinate(2, q);
        q.set(1.0f, 1.0f);
        plane.setTextureCoordinate(3, q);
        Appearance appear = new Appearance();
        TextureLoader loader = new TextureLoader(bimage);
        ImageComponent2D image = loader.getImage();
        if (Debug.debugging((String)"3d")) {
            Debug.output((String)("MapContent: image height: " + image.getHeight() + ", width: " + image.getWidth()));
        }
        Texture2D texture = new Texture2D(1, 6, image.getWidth(), image.getHeight());
        texture.setImage(0, (ImageComponent)image);
        appear.setTexture((Texture)texture);
        appear.setTransparencyAttributes(new TransparencyAttributes(0, 0.1f));
        Shape3D planeObj = new Shape3D((Geometry)plane, appear);
        this.addChild((Node)planeObj);
    }
}

