/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.wanderer;

import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OneWaySync
extends Wanderer
implements WandererCallback {
    protected File src;
    protected File tgt;
    public String[] dirSuffixAvoids = null;
    public String[] fileSuffixAvoids = null;
    public String[] dirSuffixLimits = null;
    public String[] fileSuffixLimits = null;
    protected LinkedList<File> notCopiedList = new LinkedList();
    protected boolean verbose = false;
    protected boolean fakeit = false;
    protected boolean overwrite = true;

    public OneWaySync(String srcDirName, String targetDirName) {
        this.setCallback(this);
        this.src = new File(srcDirName);
        this.tgt = new File(targetDirName);
    }

    protected boolean checkToSkipDirectory(String name) {
        int i;
        if (this.dirSuffixAvoids != null) {
            for (i = 0; i < this.dirSuffixAvoids.length; ++i) {
                if (!name.endsWith(this.dirSuffixAvoids[i])) continue;
                return true;
            }
        }
        if (this.dirSuffixLimits != null) {
            for (i = 0; i < this.dirSuffixLimits.length; ++i) {
                if (!name.endsWith(this.dirSuffixLimits[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean checkToSkipFile(String name) {
        int i;
        if (this.fileSuffixAvoids != null) {
            for (i = 0; i < this.fileSuffixAvoids.length; ++i) {
                if (!name.endsWith(this.fileSuffixAvoids[i])) continue;
                return true;
            }
        }
        if (this.fileSuffixLimits != null) {
            for (i = 0; i < this.fileSuffixLimits.length; ++i) {
                if (!name.endsWith(this.fileSuffixLimits[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean handleDirectory(File directory, String[] contentNames) {
        String newDirName = this.getRelativePathFromSource(directory);
        if (newDirName == null) {
            if (directory != this.src) {
                this.notCopiedList.add(directory);
            }
            super.handleDirectory(directory, contentNames);
            return true;
        }
        if (!this.checkToSkipDirectory(newDirName)) {
            File newDir = this.getTargetFile(newDirName);
            if (!newDir.exists()) {
                if (this.verbose) {
                    OneWaySync.getLogger().info("Creating " + newDir);
                }
                if (!this.fakeit && this.overwrite) {
                    newDir.mkdir();
                }
            }
            super.handleDirectory(directory, contentNames);
        } else {
            this.notCopiedList.add(directory);
        }
        return true;
    }

    public boolean handleDirectory(File file) {
        return true;
    }

    public boolean handleFile(File file) {
        String newFileName = this.getRelativePathFromSource(file);
        if (!this.checkToSkipFile(newFileName)) {
            File newFile = this.getTargetFile(newFileName);
            if (this.verbose) {
                OneWaySync.getLogger().info("Copying " + file + " to " + newFile);
            }
            if (!this.fakeit && this.overwrite) {
                this.copy(file, newFile);
            }
        } else {
            this.notCopiedList.add(file);
        }
        return true;
    }

    public void copy(File fromFile, File toFile) {
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            FileOutputStream fos = new FileOutputStream(toFile);
            int num = 0;
            byte[] stuff = new byte[4096];
            while ((num = fis.read(stuff)) > 0) {
                fos.write(stuff, 0, num);
            }
            fis.close();
            fos.close();
        }
        catch (IOException ioe) {
            OneWaySync.getLogger().warning("Exception reading from " + fromFile + " and writing to " + toFile);
        }
    }

    public String getRelativePathFromSource(File file) {
        return this.subtractPathFromDirectory(this.src, file);
    }

    public String getRelativePathFromTarget(File file) {
        return this.subtractPathFromDirectory(this.tgt, file);
    }

    public File getSourceFile(String relativePath) {
        return new File(this.src, relativePath);
    }

    public File getTargetFile(String relativePath) {
        return new File(this.tgt, relativePath);
    }

    public void writeUnsynched() {
        Iterator it = this.notCopiedList.iterator();
        while (it.hasNext()) {
            OneWaySync.getLogger().info("  " + it.next());
        }
    }

    public void checkTargetSolos() {
        new BackCheck(this.tgt.getPath(), this.src.getPath());
    }

    protected String subtractPathFromDirectory(File dir, File file) {
        String dirName;
        String name = file.getPath();
        if (name.equals(dirName = dir.getPath())) {
            if (this.verbose) {
                OneWaySync.getLogger().info("OneWaySync avoiding subtraction operation on top-level directory");
            }
            return null;
        }
        int index = name.indexOf(dirName);
        if (index != -1) {
            try {
                String relative = name.substring(index + dirName.length() + 1);
                if (this.verbose) {
                    OneWaySync.getLogger().info("From " + file + ", returning " + relative);
                }
                return relative;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                OneWaySync.getLogger().warning("Problem clipping first " + (dirName.length() + 1) + " characters off " + file);
                return null;
            }
        }
        OneWaySync.getLogger().warning("File " + file + " is not in directory " + dir);
        return null;
    }

    public void start() {
        String errorMessage = null;
        if (this.src == null) {
            errorMessage = "OneWaySync:  Source directory unspecified";
        } else if (!this.src.exists()) {
            errorMessage = "OneWaySync:  Source directory (" + this.src + ") doesn't exist!";
        }
        if (this.tgt != null) {
            if (!this.tgt.exists()) {
                if (this.verbose) {
                    OneWaySync.getLogger().info("OneWaySync:  target directory (" + this.tgt + ") doesn't exist, creating...");
                }
                try {
                    if (!this.fakeit && !this.tgt.mkdir()) {
                        errorMessage = "OneWaySync:  target directory (" + this.tgt + ") can't be created.";
                    }
                }
                catch (SecurityException se) {
                    errorMessage = "OneWaySync:  creating target directory (" + this.tgt + ") isn't allowed, Security Exception: " + se.getMessage();
                    se.printStackTrace();
                }
            }
        } else {
            errorMessage = "OneWaySync:  target directory unspecified";
        }
        if (errorMessage != null) {
            OneWaySync.getLogger().warning(errorMessage);
            System.exit(0);
        }
        this.handleEntry(this.src);
    }

    public void setVerbose(boolean val) {
        this.verbose = val;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setFakeit(boolean val) {
        this.fakeit = val;
    }

    public boolean getFakeit() {
        return this.fakeit;
    }

    public void setDirSuffixAvoids(String[] avoids) {
        this.dirSuffixAvoids = avoids;
    }

    public void setFileSuffixAvoids(String[] avoids) {
        this.fileSuffixAvoids = avoids;
    }

    public void setDirSuffixLimits(String[] limits) {
        this.dirSuffixLimits = limits;
    }

    public void setFileSuffixLimits(String[] limits) {
        this.fileSuffixLimits = limits;
    }

    private static Logger getLogger() {
        return LoggerHolder.LOGGER;
    }

    public static void main(String[] argv) {
        String[] targetDir;
        String[] sourceDir;
        ArgParser ap = new ArgParser("OneWaySync");
        ap.add("source", "The source directory to copy files and directories from.", 1);
        ap.add("target", "The target directory to receive the updated files and directories.", 1);
        ap.add("verbose", "Announce all changes, failures will still be reported.");
        ap.add("fakeit", "Just print what would happen, don't really do anything.");
        ap.add("report", "Print out what didn't get copied, and what files exist only on the target side.");
        if (argv.length < 4) {
            ap.bail("", true);
        }
        ap.parse(argv);
        boolean verbose = false;
        String[] verb = ap.getArgValues("verbose");
        if (verb != null) {
            verbose = true;
        }
        boolean fakeit = false;
        verb = ap.getArgValues("fakeit");
        if (verb != null) {
            verbose = true;
            fakeit = true;
        }
        boolean report = false;
        verb = ap.getArgValues("report");
        if (verb != null) {
            report = true;
        }
        if ((sourceDir = ap.getArgValues("source")) != null && sourceDir.length >= 1) {
            if (verbose) {
                OneWaySync.getLogger().info("Source directory is " + sourceDir[0]);
            }
        } else {
            ap.bail("OneWaySync needs path to source directory", false);
        }
        if ((targetDir = ap.getArgValues("target")) != null && targetDir.length >= 1) {
            if (verbose) {
                OneWaySync.getLogger().info("Target directory is " + targetDir[0]);
            }
        } else {
            ap.bail("OneWaySync needs path to source directory", false);
        }
        if (sourceDir != null && targetDir != null) {
            OneWaySync cc = new OneWaySync(sourceDir[0], targetDir[0]);
            cc.setVerbose(verbose);
            cc.setFakeit(fakeit);
            cc.setDirSuffixAvoids(new String[]{"CVS"});
            cc.setFileSuffixLimits(new String[]{".java", "Makefile", ".cvsignore", ".html", ".properties", ".txt", ".c", ".h", ".png"});
            cc.start();
            if (report) {
                OneWaySync.getLogger().info("-------- Not Copied --------");
                cc.writeUnsynched();
                OneWaySync.getLogger().info("----------------------------");
                cc.checkTargetSolos();
            }
        }
    }

    public static class BackCheck
    extends OneWaySync {
        public BackCheck(String targetDirName, String srcDirName) {
            super(targetDirName, srcDirName);
            this.fakeit = true;
            this.overwrite = false;
            if (OneWaySync.getLogger().isLoggable(Level.FINE)) {
                this.verbose = true;
            }
            this.start();
            OneWaySync.getLogger().info("-------- Only In Target Directory--------");
            this.writeUnsynched();
            OneWaySync.getLogger().info("-----------------------------------------");
        }

        public boolean handleDirectory(File directory, String[] contentNames) {
            String newDirName = this.getRelativePathFromSource(directory);
            if (newDirName == null) {
                return super.handleDirectory(directory, contentNames);
            }
            File newDir = this.getTargetFile(newDirName);
            if (!newDir.exists()) {
                this.notCopiedList.add(directory);
            }
            return super.handleDirectory(directory, contentNames);
        }

        public boolean handleFile(File file) {
            if (!this.getTargetFile(this.getRelativePathFromSource(file)).exists()) {
                this.notCopiedList.add(file);
            }
            return true;
        }
    }

    private static final class LoggerHolder {
        private static final Logger LOGGER = Logger.getLogger(OneWaySync.class.getName());

        private LoggerHolder() {
            throw new AssertionError((Object)"The LoggerHolder should never be instantiated");
        }
    }
}

