/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class WebBrowser {
    InfoDisplayListener info = null;

    protected String writeFileAndGenerateURL(String text) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("openmap", ".html", new File(Environment.get("openmap.TempDirectory")));
            tmpFile.deleteOnExit();
            FileOutputStream fs = new FileOutputStream(tmpFile);
            PrintWriter out = new PrintWriter(fs);
            out.println(text);
            fs.close();
            String urlString = tmpFile.toURI().toURL().toString();
            Debug.output("WebBrowser: created " + urlString);
            return urlString;
        }
        catch (SecurityException se) {
            Debug.error("WebBrowser.writeAndGenerateURL: " + se);
        }
        catch (IOException ioe) {
            Debug.error("WebBrowser.writeAndGenerateURL: " + ioe);
        }
        this.postErrorMessage("Cannot write to temp file:" + (tmpFile != null ? tmpFile.getAbsolutePath() : "unknown"));
        return null;
    }

    public void setInfoDelegator(InfoDisplayListener info) {
        this.info = info;
    }

    public abstract void launch(String var1);

    public void writeAndLaunch(String text) {
        this.launch(this.writeFileAndGenerateURL(text));
    }

    private void postErrorMessage(String message) {
        this.info.requestMessage(new InfoDisplayEvent(this, message));
    }
}

