/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.dataAccess.cgm.CGM;
import com.bbn.openmap.tools.symbology.milStd2525.CodeOptions;
import com.bbn.openmap.tools.symbology.milStd2525.CodePosition;
import com.bbn.openmap.tools.symbology.milStd2525.CodeScheme;
import com.bbn.openmap.util.Debug;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SymbolPart {
    public static final String DEFAULT_SYMBOL_CODE = "               ";
    public static final String NameProperty = "name";
    public static final String CGMProperty = "cgm";
    protected CodePosition codePosition;
    protected String code;
    protected String prettyName;
    protected String cgmName;
    protected CGM cgm;
    protected List subs;
    protected SymbolPart parent;
    protected int positionShift = 0;
    protected static boolean DEBUG = false;
    public static final char UNUSED = '-';
    public static final char WILD = '*';

    protected SymbolPart() {
        DEBUG = Debug.debugging("symbolpart");
    }

    public SymbolPart(CodePosition codePosition, String symbolCode, Properties props, SymbolPart parent) {
        this(codePosition, symbolCode, props, parent, codePosition.getStartIndex(), codePosition.getEndIndex(), true);
    }

    public SymbolPart(CodePosition codePosition, String symbolCode, Properties props, SymbolPart parent, int start, int end, boolean shiftIfNecessary) {
        this.code = symbolCode.substring(start, end);
        this.codePosition = codePosition;
        boolean debug = DEBUG;
        while (this.code.charAt(0) == '-' && start > 1 && shiftIfNecessary) {
            this.code = symbolCode.substring(--start, end);
            --this.positionShift;
        }
        this.prettyName = props.getProperty(symbolCode + "." + NameProperty);
        this.cgmName = props.getProperty(symbolCode + "." + CGMProperty);
        this.parent = parent;
        String sc = this.getSymbolCode();
        if (Debug.debugging("errors") && !symbolCode.equals(sc)) {
            debug = true;
        }
        if (debug) {
            Debug.output("SymbolPart(" + codePosition.getPrettyName() + "): read " + start + " of [" + symbolCode + "] as [" + sc + "] : " + this.prettyName + " (" + this.code + ")");
        }
    }

    public void setCode(String c) {
        this.code = c;
    }

    public String getCode() {
        return this.code;
    }

    public void setPrettyName(String pn) {
        this.prettyName = pn;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setParent(SymbolPart par) {
        this.parent = par;
    }

    public SymbolPart getParent() {
        return this.parent;
    }

    public void setSubs(List set) {
        this.subs = set;
    }

    public List getSubs() {
        return this.subs;
    }

    public String toString() {
        return this.prettyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(int level) {
        StringBuffer sb = new StringBuffer();
        String indicator = "|--> ";
        if (level > 0) {
            sb.append(indicator);
        }
        List subs = this.getSubs();
        int subSize = 0;
        if (subs != null) {
            subSize = subs.size();
        }
        sb.append(this.toString());
        if (subSize > 0) {
            sb.append(" with ").append(subSize).append(" subcategor").append(subSize == 1 ? "y\n" : "ies\n");
        } else {
            sb.append("\n");
        }
        if (subs != null) {
            SymbolPart symbolPart = this;
            synchronized (symbolPart) {
                StringBuffer sb1 = new StringBuffer();
                for (int i = 0; i < level; ++i) {
                    sb1.append("     ");
                }
                String spacer = sb1.toString();
                Iterator it = subs.iterator();
                while (it.hasNext()) {
                    sb.append(spacer).append(((SymbolPart)it.next()).getDescription(level + 1));
                }
            }
        }
        return sb.toString();
    }

    public String getDescription() {
        return this.getDescription(0);
    }

    public String getSymbolCode() {
        return this.getSymbolCode(null).toString();
    }

    public StringBuffer getSymbolCodeMask() {
        return new StringBuffer(DEFAULT_SYMBOL_CODE);
    }

    protected StringBuffer getSymbolCode(StringBuffer symbolCode) {
        symbolCode = this.codePosition instanceof CodeScheme ? ((CodeScheme)this.codePosition).getDefaultSymbolCode() : (this.parent != null ? this.parent.getSymbolCode(symbolCode) : this.getSymbolCodeMask());
        if (this.codePosition != null) {
            int key = this.codePosition.getStartIndex() + this.positionShift;
            symbolCode = symbolCode.replace(key, this.codePosition.getEndIndex(), this.code);
        }
        return symbolCode;
    }

    public CodePosition getCodePosition() {
        return this.codePosition;
    }

    public CodeOptions getCodeOptions() {
        CodeScheme cs = this.getCodeScheme();
        if (cs != null) {
            return cs.getCodeOptions(this);
        }
        return null;
    }

    public CodeScheme getCodeScheme() {
        CodeScheme cs = null;
        if (this.codePosition instanceof CodeScheme) {
            cs = (CodeScheme)this.codePosition;
        } else if (this.parent != null) {
            cs = this.parent.getCodeScheme();
        }
        return cs;
    }

    public boolean codeMatches(String queryCode) {
        if (this.codePosition != null && this.code != null) {
            int startIndex = this.codePosition.startIndex;
            int length = this.code.indexOf(45);
            if (length == -1) {
                length = this.code.length();
            }
            if (Debug.debugging("symbology.detail")) {
                Debug.output("Checking " + queryCode + " against |" + this.code + "| starting at " + startIndex + " for " + length);
            }
            return queryCode.regionMatches(true, startIndex, this.code, 0, length);
        }
        return true;
    }

    public void paintIcon(Graphics2D g, CodeOptions co, Dimension di) {
    }
}

