/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.tools.symbology.milStd2525.CodePosition;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.Properties;

public class CodeFunctionID
extends CodePosition {
    public CodeFunctionID() {
        this(5);
    }

    public CodeFunctionID(int pos) {
        super("Function ID", pos, 10);
    }

    public void parseHierarchy(String hCode, Properties props, SymbolPart parent) {
        ArrayList<SymbolPart> parentList = null;
        int subLevelNumber = 1;
        int pos = this.getStartIndex() + parent.positionShift;
        if (pos < 4) {
            pos = 4;
        }
        if (pos == 10) {
            return;
        }
        CodeFunctionID cp = new CodeFunctionID(pos + 2);
        while (subLevelNumber > 0) {
            String hCode2 = hCode + "." + subLevelNumber;
            String entry = props.getProperty(hCode2);
            if (entry != null) {
                if (this.DEBUG) {
                    Debug.output("CodeFunctionID.parse: reading " + hCode2 + " as " + entry);
                }
                SymbolPart sp = new SymbolPart(cp, entry, props, parent);
                if (parentList == null && (parentList = parent.getSubs()) == null) {
                    parentList = new ArrayList<SymbolPart>();
                    parent.setSubs(parentList);
                }
                if (this.DEBUG) {
                    Debug.output("CodeFunctionID.parse: adding " + sp.getPrettyName() + " to " + parent.getPrettyName());
                }
                parentList.add(sp);
                if (this.DEBUG) {
                    Debug.output("CodePosition.parse: looking for children of " + sp.getPrettyName());
                }
                cp.parseHierarchy(hCode2, props, sp);
                ++subLevelNumber;
                continue;
            }
            subLevelNumber = -1;
        }
    }
}

