/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.roads.Intersection;
import com.bbn.openmap.tools.roads.Road;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class Route
implements Cloneable,
Serializable {
    private static float MSEC_PER_HOUR = 3600000.0f;
    private String name = null;
    Road[] roads;
    private boolean startWithFirstIntersection;
    transient Logger logger = Logger.getLogger(this.getClass().getName());

    public static synchronized Route getBestRoute(Intersection from, Intersection to, double bestConvoySpeed, double worstConvoySpeed) {
        Hashtable<Intersection, NodeInfo> marks = new Hashtable<Intersection, NodeInfo>();
        boolean haveRoute = false;
        LatLonPoint toLoc = to.getLocation();
        double toLat = toLoc.getY();
        double toLon = toLoc.getX();
        LatLonPoint fromLoc = from.getLocation();
        double fromLat = fromLoc.getY();
        double fromLon = fromLoc.getX();
        double timeLimitBase = GreatCircle.sphericalDistance(toLat, toLon, fromLat, fromLon) / worstConvoySpeed;
        double bestTime = Double.MAX_VALUE;
        for (float snakeFactor = 1.0f; snakeFactor < 40.0f; snakeFactor *= 2.0f) {
            double timeLimit = timeLimitBase * (double)snakeFactor;
            Vector<Intersection> toDo = new Vector<Intersection>();
            toDo.addElement(from);
            marks.clear();
            marks.put(from, new NodeInfo(from, null, 0.0, 0.0));
            while (!toDo.isEmpty()) {
                Vector<Intersection> newToDo = new Vector<Intersection>();
                Enumeration e = toDo.elements();
                while (e.hasMoreElements()) {
                    Intersection thisIntersection = (Intersection)e.nextElement();
                    NodeInfo thisInfo = (NodeInfo)marks.get(thisIntersection);
                    Enumeration e2 = thisIntersection.getRoads();
                    while (e2.hasMoreElements()) {
                        Road road = (Road)e2.nextElement();
                        double roadTime = road.getTraverseHours();
                        double newTime = thisInfo.time + roadTime;
                        if (newTime > timeLimit) continue;
                        Intersection nextIntersection = road.getOtherIntersection(thisIntersection);
                        NodeInfo nextInfo = (NodeInfo)marks.get(nextIntersection);
                        if (nextInfo == null) {
                            LatLonPoint nextLoc = nextIntersection.getLocation();
                            double crowsPathDistance = GreatCircle.sphericalDistance(toLat, toLon, nextLoc.getY(), nextLoc.getX());
                            double crowsPathHours = crowsPathDistance / bestConvoySpeed;
                            nextInfo = new NodeInfo(nextIntersection, road, newTime, crowsPathHours);
                            marks.put(nextIntersection, nextInfo);
                            if (newTime + nextInfo.crowsPathHours > bestTime) continue;
                            newToDo.addElement(nextIntersection);
                        } else {
                            if (!(nextInfo.time > newTime)) continue;
                            if (!nextInfo.intersection.equals(nextIntersection)) {
                                System.err.println("huh?  lookup of " + nextIntersection + " gets node info with inter " + nextInfo.intersection);
                            }
                            nextInfo.time = newTime;
                            nextInfo.bestRoad = road;
                            if (newTime + nextInfo.crowsPathHours > bestTime) continue;
                            newToDo.addElement(nextIntersection);
                        }
                        if (nextIntersection != to) continue;
                        bestTime = nextInfo.time;
                        haveRoute = true;
                    }
                }
                toDo = newToDo;
            }
            if (haveRoute) break;
        }
        Vector<Road> roadVector = new Vector<Road>();
        Route result = null;
        if (haveRoute) {
            NodeInfo info = (NodeInfo)marks.get(to);
            while (result == null) {
                roadVector.addElement(info.bestRoad);
                Intersection prevIntersection = info.bestRoad.getOtherIntersection(info.intersection);
                if (prevIntersection == from) {
                    result = new Route(roadVector, info.bestRoad.getFirstIntersection() == prevIntersection);
                    continue;
                }
                info = (NodeInfo)marks.get(prevIntersection);
            }
        }
        marks = null;
        return result;
    }

    public Route(String name, Road[] roads, boolean startWithFirstIntersection) {
        this.name = name;
        this.roads = roads;
        this.startWithFirstIntersection = startWithFirstIntersection;
    }

    private Route(Vector roadVector, boolean startWithFirstIntersection) {
        int nRoads = roadVector.size();
        this.roads = new Road[nRoads];
        for (int i = 0; i < nRoads; ++i) {
            this.roads[i] = (Road)roadVector.elementAt(nRoads - 1 - i);
        }
        this.startWithFirstIntersection = startWithFirstIntersection;
    }

    public Object clone() {
        return new Route(null, this.roads, this.startWithFirstIntersection);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Road[] getRoads() {
        return this.roads;
    }

    public int getBlockedRoadCount() {
        int blockedRoadCount = 0;
        for (int i = 0; i < this.roads.length; ++i) {
            if (!this.roads[i].isBlocked()) continue;
            ++blockedRoadCount;
        }
        return blockedRoadCount;
    }

    public void unblockBlockedRoads() {
        for (int i = 0; i < this.roads.length; ++i) {
            if (!this.roads[i].isBlocked()) continue;
            this.roads[i].unblock();
        }
    }

    public Intersection getOriginIntersection() {
        if (this.startWithFirstIntersection) {
            return this.roads[0].getFirstIntersection();
        }
        return this.roads[0].getSecondIntersection();
    }

    public Intersection getDestinationIntersection() {
        Intersection x = this.getOriginIntersection();
        for (int i = 0; i < this.roads.length; ++i) {
            x = this.roads[i].getOtherIntersection(x);
        }
        return x;
    }

    public long getTravelTime() {
        double hours = 0.0;
        for (int i = 0; i < this.roads.length; ++i) {
            Road road = this.roads[i];
            double roadLength = road.getLengthInKilometers();
            double convoySpeed = road.getRoadClass().getConvoySpeed();
            double timeToTraverse = roadLength / convoySpeed;
            hours += timeToTraverse;
        }
        return (long)(hours * (double)MSEC_PER_HOUR);
    }

    public LatLonPoint location(long time) {
        double hours = (float)time / MSEC_PER_HOUR;
        Intersection from = this.startWithFirstIntersection ? this.roads[0].getFirstIntersection() : this.roads[0].getSecondIntersection();
        for (int i = 0; i < this.roads.length; ++i) {
            double convoySpeed;
            Road road = this.roads[i];
            boolean forward = road.getFirstIntersection() == from;
            double roadLength = road.getLengthInKilometers();
            double timeToTraverse = roadLength / (convoySpeed = (double)road.getRoadClass().getConvoySpeed());
            if (timeToTraverse > hours) {
                float fraction = (float)hours / (float)timeToTraverse;
                if (!forward) {
                    fraction = 1.0f - fraction;
                }
                return road.getLocationAtKilometer(roadLength * (double)fraction);
            }
            hours -= timeToTraverse;
            from = forward ? road.getSecondIntersection() : road.getFirstIntersection();
        }
        return from.getLocation();
    }

    static class NodeInfo {
        Intersection intersection;
        Road bestRoad = null;
        double time;
        double crowsPathHours;

        NodeInfo(Intersection intersection, Road road, double time, double crowsPathHours) {
            this.intersection = intersection;
            this.bestRoad = road;
            this.time = time;
            this.crowsPathHours = crowsPathHours;
        }
    }
}

