/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.geom.Point2D;

public abstract class MercatorUVGCT
extends AbstractGCT
implements GeoCoordTransformation {
    int zoomLevel;

    protected MercatorUVGCT(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public abstract Point2D forward(double var1, double var3, Point2D var5);

    public abstract LatLonPoint inverse(double var1, double var3, LatLonPoint var5);

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public static class TMS
    extends MercatorUVGCT {
        public TMS(int zoomLevel) {
            super(zoomLevel);
        }

        public Point2D forward(double lat, double lon, Point2D ret) {
            if (ret == null) {
                ret = new Point2D.Double();
            }
            ret.setLocation((lon + 180.0) / 360.0 * Math.pow(2.0, this.zoomLevel), Math.pow(2.0, this.zoomLevel) - (1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) / 2.0 * Math.pow(2.0, this.zoomLevel));
            return ret;
        }

        public LatLonPoint inverse(double uvx, double uvy, LatLonPoint ret) {
            if (ret == null) {
                ret = new LatLonPoint.Double();
            }
            ret.setLocation(360.0 / Math.pow(2.0, this.zoomLevel) * uvx - 180.0, -90.0 + 114.59155902616465 * Math.atan(Math.exp(Math.PI * -2 * -(uvy - Math.pow(2.0, this.zoomLevel)) / Math.pow(2.0, this.zoomLevel) + Math.PI)));
            return ret;
        }
    }

    public static class OSM
    extends MercatorUVGCT {
        public OSM(int zoomLevel) {
            super(zoomLevel);
        }

        public Point2D forward(double lat, double lon, Point2D ret) {
            if (ret == null) {
                ret = new Point2D.Double();
            }
            ret.setLocation((lon + 180.0) / 360.0 * Math.pow(2.0, this.zoomLevel), (1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) / 2.0 * Math.pow(2.0, this.zoomLevel));
            return ret;
        }

        public LatLonPoint inverse(double uvx, double uvy, LatLonPoint ret) {
            if (ret == null) {
                ret = new LatLonPoint.Double();
            }
            ret.setLocation(360.0 / Math.pow(2.0, this.zoomLevel) * uvx - 180.0, -90.0 + 114.59155902616465 * Math.atan(Math.exp(Math.PI * -2 * uvy / Math.pow(2.0, this.zoomLevel) + Math.PI)));
            return ret;
        }
    }
}

