/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.coords.ECEFPoint;

public class HelmertTransformation {
    private static final int TYPE_POSITION_VECTOR = 1;
    private static final int TYPE_COORDINATE_FRAME = 2;
    public static final HelmertTransformation WGS84_TO_ED50_N62N = new HelmertTransformation(116.641, 56.931, 110.559, -4.327E-6, -4.464E-6, 4.444E-6, HelmertTransformation.ppmToM(3.52), 1);
    public static final HelmertTransformation ED50_TO_WGS84_N62N = WGS84_TO_ED50_N62N.createReverse();
    public static final HelmertTransformation WGS84_TO_ED50_S62N = new HelmertTransformation(90.365, 101.13, 123.384, -1.614E-6, -3.73E-7, -4.334E-6, HelmertTransformation.ppmToM(-1.994), 1);
    private static final HelmertTransformation ED50_TO_WGS84_S62N = WGS84_TO_ED50_S62N.createReverse();
    private final double dX;
    private final double dY;
    private final double dZ;
    private final double rX;
    private final double rY;
    private final double rZ;
    private final double neg_rX;
    private final double neg_rY;
    private final double neg_rZ;
    private final double m;
    private final int type;

    public static final HelmertTransformation find(Ellipsoid source, Ellipsoid dest) {
        if (source == Ellipsoid.WGS_84 && dest == Ellipsoid.INTERNATIONAL) {
            return WGS84_TO_ED50_S62N;
        }
        if (source == Ellipsoid.INTERNATIONAL && dest == Ellipsoid.WGS_84) {
            return ED50_TO_WGS84_S62N;
        }
        throw new IllegalArgumentException("Unknown transformation from " + source + " to " + dest);
    }

    private HelmertTransformation(double dX, double dY, double dZ, double rX, double rY, double rZ, double m, int type) {
        this.dX = dX;
        this.dY = dY;
        this.dZ = dZ;
        this.rX = rX;
        this.rY = rY;
        this.rZ = rZ;
        this.neg_rX = -1.0 * rX;
        this.neg_rY = -1.0 * rY;
        this.neg_rZ = -1.0 * rZ;
        this.m = m;
        this.type = type;
    }

    private HelmertTransformation createReverse() {
        double newM = 2.0 - this.m;
        return new HelmertTransformation(-1.0 * this.dX, -1.0 * this.dY, -1.0 * this.dZ, this.neg_rX, this.neg_rY, this.neg_rZ, newM, this.type);
    }

    public void apply(ECEFPoint coord) {
        double x = coord.x_;
        double y = coord.y_;
        double z = coord.z_;
        x *= this.m;
        y *= this.m;
        z *= this.m;
        switch (this.type) {
            case 1: {
                x = x + this.neg_rZ * y + this.rX * z;
                y = this.rZ * x + y + this.neg_rX * z;
                z = this.neg_rY * x + this.rX * y + z;
                break;
            }
            case 2: {
                x = x + this.rZ * y + this.neg_rX * z;
                y = this.neg_rZ * x + y + this.rX * z;
                z = this.rY * x + this.neg_rX * y + z;
            }
        }
        coord.setECEF(x += this.dX, y += this.dY, z += this.dZ);
    }

    private static final double ppmToM(double ppm) {
        return 1.0 + ppm / 1000000.0;
    }
}

