/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Assert;

public class DMSLatLonPoint
implements Cloneable {
    private static final double MINUTE = 0.016666666666666666;
    private static final double SECOND = 2.777777777777778E-4;
    public boolean lat_isnegative;
    public int lat_degrees;
    public int lat_minutes;
    public double lat_seconds;
    public boolean lon_isnegative;
    public int lon_degrees;
    public int lon_minutes;
    public double lon_seconds;

    public DMSLatLonPoint() {
    }

    public DMSLatLonPoint(int lat_degrees, int lat_minutes, double lat_seconds, int lon_degrees, int lon_minutes, double lon_seconds) {
        this(lat_degrees < 0, Math.abs(lat_degrees), lat_minutes, lat_seconds, lon_degrees < 0, Math.abs(lon_degrees), lon_minutes, lon_seconds);
    }

    public DMSLatLonPoint(boolean lat_isnegative, int lat_degrees, int lat_minutes, double lat_seconds, boolean lon_isnegative, int lon_degrees, int lon_minutes, double lon_seconds) {
        this.lat_isnegative = lat_isnegative;
        this.lat_degrees = (int)LatLonPoint.normalizeLatitude(lat_degrees);
        if (this.lat_degrees < 0) {
            this.lat_degrees = -this.lat_degrees;
        }
        this.lat_minutes = DMSLatLonPoint.normalize_value(lat_minutes);
        this.lat_seconds = DMSLatLonPoint.normalize_value(lat_seconds);
        this.lon_isnegative = lon_isnegative;
        this.lon_degrees = (int)LatLonPoint.wrapLongitude(lon_degrees);
        if (this.lon_degrees < 0) {
            this.lon_degrees = -this.lon_degrees;
        }
        this.lon_minutes = DMSLatLonPoint.normalize_value(lon_minutes);
        this.lon_seconds = DMSLatLonPoint.normalize_value(lon_seconds);
    }

    public DMSLatLonPoint(int lat_degrees, double lat_minutesDotSeconds, int lon_degrees, double lon_minutesDotSeconds) {
        this.lat_isnegative = lat_degrees < 0;
        this.lat_degrees = (int)LatLonPoint.normalizeLatitude(Math.abs(lat_degrees));
        double lat_minDSec = Math.abs(lat_minutesDotSeconds);
        this.lat_minutes = DMSLatLonPoint.normalize_value((int)lat_minDSec);
        this.lat_seconds = DMSLatLonPoint.normalize_value((lat_minDSec - (double)this.lat_minutes) * 60.0);
        this.lon_isnegative = lon_degrees < 0;
        this.lon_degrees = (int)LatLonPoint.wrapLongitude(Math.abs(lon_degrees));
        double lon_minDSec = Math.abs(lon_minutesDotSeconds);
        this.lon_minutes = DMSLatLonPoint.normalize_value((int)lon_minDSec);
        this.lon_seconds = DMSLatLonPoint.normalize_value((lon_minDSec - (double)this.lon_minutes) * 60.0);
    }

    public DMSLatLonPoint(LatLonPoint llp) {
        DMSLatLonPoint.getDMSLatLonPoint(llp, this);
    }

    static void getDMSLatLonPoint(LatLonPoint llp, DMSLatLonPoint dllp) {
        int min;
        double rem;
        int deg;
        dllp.lat_degrees = 0;
        dllp.lat_minutes = 0;
        dllp.lat_seconds = 0.0;
        dllp.lat_isnegative = false;
        dllp.lon_degrees = 0;
        dllp.lon_minutes = 0;
        dllp.lon_seconds = 0.0;
        dllp.lon_isnegative = false;
        double val = llp.getY();
        if (val < 0.0) {
            dllp.lat_isnegative = true;
            val = -val;
        }
        dllp.lat_degrees = (int)Math.floor(val);
        if (val >= 2.777777777777778E-4) {
            deg = (int)val;
            rem = val - (double)deg;
            if (rem >= 0.016666666666666666) {
                dllp.lat_minutes = min = (int)(rem * 60.0);
                rem -= (double)min * 0.016666666666666666;
            }
            if (rem >= 2.777777777777778E-4) {
                double sec;
                dllp.lat_seconds = sec = rem * 3600.0;
                rem -= sec * 2.777777777777778E-4;
            }
        } else {
            dllp.lat_isnegative = false;
        }
        val = llp.getX();
        if (val < 0.0) {
            dllp.lon_isnegative = true;
            val = -val;
        }
        dllp.lon_degrees = (int)Math.floor(val);
        if (val >= 2.777777777777778E-4) {
            deg = (int)val;
            rem = val - (double)deg;
            if (rem >= 0.016666666666666666) {
                dllp.lon_minutes = min = (int)(rem * 60.0);
                rem -= (double)min * 0.016666666666666666;
            }
            if (rem >= 2.777777777777778E-4) {
                double sec;
                dllp.lon_seconds = sec = rem * 3600.0;
                rem -= sec * 2.777777777777778E-4;
            }
        } else {
            dllp.lon_isnegative = false;
        }
    }

    public LatLonPoint getLatLonPoint() {
        return this.getLatLonPoint(null);
    }

    public LatLonPoint getLatLonPoint(LatLonPoint llp) {
        double lat = this.getDecimalLatitude();
        double lon = this.getDecimalLongitude();
        if (llp == null) {
            return new LatLonPoint.Double(lat, lon);
        }
        llp.setLatLon(lat, lon);
        return llp;
    }

    public double getDecimalLatitude() {
        double val = (double)this.lat_degrees + (double)this.lat_minutes * 0.016666666666666666 + this.lat_seconds * 2.777777777777778E-4;
        return this.lat_isnegative ? -val : val;
    }

    public double getDecimalLongitude() {
        double val = (double)this.lon_degrees + (double)this.lon_minutes * 0.016666666666666666 + this.lon_seconds * 2.777777777777778E-4;
        return this.lon_isnegative ? -val : val;
    }

    public String toString() {
        return "DMSLatLonPoint[lat_isnegative = " + this.lat_isnegative + ", lat_degrees = " + this.lat_degrees + ", lat_minutes = " + this.lat_minutes + ", lat_seconds = " + this.lat_seconds + ", lon_isnegative = " + this.lon_isnegative + ", lon_degrees = " + this.lon_degrees + ", lon_minutes = " + this.lon_minutes + ", lon_seconds = " + this.lon_seconds + "]";
    }

    public void setDMSLatLon(DMSLatLonPoint llpt) {
        this.lat_isnegative = llpt.lat_isnegative;
        this.lat_degrees = llpt.lat_degrees;
        this.lat_minutes = llpt.lat_minutes;
        this.lat_seconds = llpt.lat_seconds;
        this.lon_isnegative = llpt.lon_isnegative;
        this.lon_degrees = llpt.lon_degrees;
        this.lon_minutes = llpt.lon_minutes;
        this.lon_seconds = llpt.lon_seconds;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.assertExp(false, "DMSLatLonPoint: internal error!");
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DMSLatLonPoint pt = (DMSLatLonPoint)obj;
        return pt.lat_isnegative == this.lat_isnegative && pt.lat_degrees == this.lat_degrees && pt.lat_minutes == this.lat_degrees && pt.lat_seconds == this.lat_seconds && pt.lon_isnegative == this.lon_isnegative && pt.lon_degrees == this.lon_degrees && pt.lon_minutes == this.lon_minutes && pt.lon_seconds == this.lon_seconds;
    }

    public static final int normalize_value(int val) {
        if ((val %= 60) < 0) {
            val += 60;
        }
        return val;
    }

    public static final double normalize_value(double val) {
        if ((val %= 60.0) < 0.0) {
            val += 60.0;
        }
        return val;
    }

    public int hashCode() {
        return this.lat_degrees | this.lon_degrees << 8 | this.lat_minutes + (int)this.lat_seconds << 16 | this.lon_minutes + (int)this.lon_seconds << 23;
    }
}

