/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.gui.MiniBrowser;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.OMWarpingImage;
import com.bbn.openmap.plugin.AbstractPlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class WebImagePlugIn
extends AbstractPlugIn
implements ImageServerConstants {
    protected PlugInLayer layer = null;
    protected Projection currentProjection = null;
    static I18n i18n = Environment.getI18n();
    public static Logger logger = Logger.getLogger("com.bbn.openmap.plugin.WebImagePlugIn");
    protected JButton redrawButton = new JButton(i18n.get(WebImagePlugIn.class, "Query_Server", "Query Server"));
    protected JOptionPane messageWindow = new JOptionPane();

    public abstract String createQueryString(Projection var1);

    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = new OMGraphicList();
        this.currentProjection = p;
        Object ul = p.getUpperLeft();
        Object lr = p.getLowerRight();
        if (((Point2D)lr).getX() < ((Point2D)ul).getX()) {
            Point2D dateline1 = p.forward(((Point2D)ul).getY(), 179.9999);
            Point2D dateline2 = p.forward(((Point2D)ul).getY(), -179.9999);
            int w1 = (int)dateline1.getX();
            int w2 = p.getWidth() - (int)dateline2.getX() - 1;
            int h = p.getHeight();
            Object c1 = p.inverse(w1 / 2, h / 2);
            Object c2 = p.inverse(w2 / 2 + w1 + 1, h / 2);
            Proj p1 = (Proj)p.makeClone();
            Proj p2 = (Proj)p.makeClone();
            p1.setCenter((Point2D)c1);
            p1.setWidth(w1);
            p2.setCenter((Point2D)c2);
            p2.setWidth(w2);
            this.fetchImageAndAddToList(p1, list);
            this.fetchImageAndAddToList(p2, list);
        } else {
            this.fetchImageAndAddToList(p, list);
        }
        list.generate(p);
        return list;
    }

    protected void fetchImageAndAddToList(Projection p, OMGraphicList list) {
        String urlString = this.createQueryString(p);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WebImagePlugIn.getRectangle() with \"" + urlString + "\"");
        }
        if (urlString == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(urlString);
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("url content type: " + urlc.getContentType());
            }
            if (urlc == null || urlc.getContentType() == null) {
                logger.info(" unable to connect to " + urlString);
                return;
            }
            if (urlc.getContentType().startsWith("text")) {
                String st;
                BufferedReader bin = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                StringBuffer message = new StringBuffer();
                while ((st = bin.readLine()) != null) {
                    message.append(st);
                }
                logger.info("Received text from\n" + urlString + ":\n" + message.toString());
            } else if (urlc.getContentType().startsWith("image")) {
                InputStream in = urlc.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int buflen = 2048;
                byte[] buf = new byte[buflen];
                int len = -1;
                while ((len = in.read(buf, 0, buflen)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
                out.close();
                ImageIcon ii = new ImageIcon(out.toByteArray());
                if (p instanceof LLXY) {
                    OMRaster image = new OMRaster(0, 0, ii);
                    list.add(image);
                } else {
                    Object ul = p.getUpperLeft();
                    Object lr = p.getLowerRight();
                    OMScalingRaster omsr = new OMScalingRaster(((Point2D)ul).getY(), ((Point2D)ul).getX(), ((Point2D)lr).getY(), ((Point2D)lr).getX(), ii);
                    OMWarpingImage omwi = new OMWarpingImage(omsr, LatLonGCT.INSTANCE);
                    list.add(omwi);
                }
            }
        }
        catch (MalformedURLException murle) {
            logger.warning("WebImagePlugIn: URL \"" + urlString + "\" is malformed.");
        }
        catch (IOException ioe) {
            this.handleMessage("Couldn't connect to " + this.getServerName());
        }
    }

    protected void handleMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, WebImagePlugIn.this.getName() + ":\n\n   " + message, "Connection Problem", 1);
            }
        });
    }

    public abstract String getServerName();

    public Component getGUI() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        JButton parameterButton = new JButton(i18n.get(WebImagePlugIn.class, "Adjust_Parameters", "Adjust Parameters"));
        parameterButton.setActionCommand("displayPropertiesCmd");
        if (this.layer != null) {
            parameterButton.addActionListener(this.layer);
        }
        JButton viewQueryButton = new JButton(i18n.get(WebImagePlugIn.class, "View_Current_Query", "View Current Query"));
        viewQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WebImagePlugIn.this.layer != null) {
                    String query = WebImagePlugIn.this.createQueryString(WebImagePlugIn.this.currentProjection);
                    Vector<String> queryStrings = PropUtils.parseMarkers(query, "&");
                    StringBuffer updatedQuery = new StringBuffer();
                    Iterator<String> it = queryStrings.iterator();
                    if (it.hasNext()) {
                        updatedQuery.append(it.next());
                    }
                    while (it.hasNext()) {
                        updatedQuery.append("&\n   ");
                        updatedQuery.append(it.next());
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        String stb = "Send Query to Browser";
                        String ok = "OK";
                        Object[] options = new Object[]{stb, ok};
                        int selectedVal = JOptionPane.showOptionDialog(null, updatedQuery, "Current Query for " + WebImagePlugIn.this.getName(), 0, 1, null, options, ok);
                        if (selectedVal == 0) {
                            try {
                                new MiniBrowser(new URL(query));
                            }
                            catch (MalformedURLException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, updatedQuery.toString(), "Current Query for " + WebImagePlugIn.this.getName(), 1);
                    }
                }
            }
        });
        this.redrawButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WebImagePlugIn.this.layer != null) {
                    WebImagePlugIn.this.layer.doPrepare();
                }
            }
        });
        this.redrawButton.setEnabled(this.layer != null);
        panel.add(parameterButton);
        panel.add(viewQueryButton);
        panel.add(this.redrawButton);
        return panel;
    }

    public void setComponent(Component comp) {
        super.setComponent(comp);
        this.layer = comp instanceof PlugInLayer ? (PlugInLayer)comp : null;
        this.redrawButton.setEnabled(this.layer != null);
    }
}

