/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.util;

import com.bbn.openmap.dataAccess.image.WorldFile;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.Debug;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageWarp {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.omGraphics.util.ImageWarp");
    protected int[] pixels = null;
    protected int iwidth;
    protected int iheight;
    protected double hor_upp;
    protected double ver_upp;
    protected double verOrigin;
    protected double horOrigin;
    protected GeoCoordTransformation geoTrans = new LatLonGCT();
    protected DataBounds sourceImageBounds;
    protected DataBounds projectedImageBounds;

    public ImageWarp(BufferedImage bi) {
        this(bi, (GeoCoordTransformation)LatLonGCT.INSTANCE, new DataBounds(-180.0, -90.0, 180.0, 90.0));
    }

    public ImageWarp(BufferedImage bi, GeoCoordTransformation transform, DataBounds imageBounds) {
        if (bi != null) {
            this.iwidth = bi.getWidth();
            this.iheight = bi.getHeight();
            this.setGeoTrans(transform);
            this.setImageBounds(imageBounds);
            this.pixels = this.getPixels(bi, 0, 0, this.iwidth, this.iheight);
            bi = null;
        }
    }

    public ImageWarp(BufferedImage bi, GeoCoordTransformation transform, WorldFile worldFile) {
        if (bi != null) {
            this.iwidth = bi.getWidth();
            this.iheight = bi.getHeight();
            this.setGeoTrans(transform);
            this.setImageBounds(worldFile);
            this.pixels = this.getPixels(bi, 0, 0, this.iwidth, this.iheight);
            bi = null;
        }
    }

    public ImageWarp(int[] pix, int width, int height) {
        this(pix, width, height, (GeoCoordTransformation)LatLonGCT.INSTANCE, new DataBounds(-180.0, -90.0, 180.0, 90.0));
    }

    public ImageWarp(int[] pix, int width, int height, GeoCoordTransformation transform, DataBounds imageBounds) {
        if (pix != null) {
            this.iwidth = width;
            this.iheight = height;
            this.setGeoTrans(transform);
            this.setImageBounds(imageBounds);
            this.pixels = pix;
        }
    }

    public ImageWarp(int[] pix, int width, int height, GeoCoordTransformation transform, WorldFile worldFile) {
        if (pix != null) {
            this.iwidth = width;
            this.iheight = height;
            this.setGeoTrans(transform);
            this.setImageBounds(worldFile);
            this.pixels = pix;
        }
    }

    public OMRaster getOMRaster(Projection p) {
        int[] pixels = this.getImagePixels(p);
        if (pixels != null && this.projectedImageBounds != null) {
            int width = (int)Math.ceil(this.projectedImageBounds.getWidth());
            int height = (int)Math.ceil(this.projectedImageBounds.getHeight());
            int x = (int)Math.floor(this.projectedImageBounds.getMin().getX());
            int y = (int)Math.floor(this.projectedImageBounds.getMin().getY());
            OMRaster raster = new OMRaster(x, y, width, height, pixels);
            raster.generate(p);
            return raster;
        }
        return null;
    }

    public int[] getImagePixels(Projection p) {
        if (this.pixels != null && p != null) {
            this.projectedImageBounds = this.calculateProjectedImageBounds(p);
            if (this.projectedImageBounds == null) {
                return null;
            }
            int projHeight = (int)Math.ceil(this.projectedImageBounds.getHeight());
            int projWidth = (int)Math.ceil(this.projectedImageBounds.getWidth());
            int[] tmpPixels = new int[projWidth * projHeight];
            int numTmpPixels = tmpPixels.length;
            logger.fine("tmpPixels[" + numTmpPixels + "]");
            int clear = 0;
            Point2D.Double ctp = new Point2D.Double();
            Point2D.Double ddll = new Point2D.Double();
            Point2D.Double imageCoord = new Point2D.Double();
            Object center = p.getCenter();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.projectedImageBounds.toString());
            }
            int minx = (int)Math.floor(this.projectedImageBounds.getMin().getX());
            int miny = (int)Math.floor(this.projectedImageBounds.getMin().getY());
            int maxx = (int)Math.ceil(this.projectedImageBounds.getMax().getX());
            int maxy = (int)Math.ceil(this.projectedImageBounds.getMax().getY());
            for (int i = minx; i < maxx; ++i) {
                for (int j = miny; j < maxy; ++j) {
                    int imageIndex;
                    int ix = i - minx;
                    int iy = j - miny;
                    int tmpIndex = ix + iy * projWidth;
                    if (tmpIndex >= numTmpPixels) continue;
                    if ((ddll = p.inverse(i, j, ddll)).equals(center)) {
                        p.forward(ddll, ctp);
                        if (((Point2D)ctp).getX() != (double)i || ((Point2D)ctp).getY() != (double)j) {
                            tmpPixels[tmpIndex] = clear;
                            continue;
                        }
                    }
                    if (this.geoTrans != null) {
                        this.geoTrans.forward(((Point2D)ddll).getY(), ((Point2D)ddll).getX(), imageCoord);
                    } else {
                        imageCoord = ddll;
                    }
                    if (!this.sourceImageBounds.contains(imageCoord)) {
                        tmpPixels[tmpIndex] = clear;
                        continue;
                    }
                    int horIndex = (int)Math.round(this.horOrigin + ((Point2D)imageCoord).getX() / this.hor_upp);
                    int verIndex = (int)Math.round(this.verOrigin + ((Point2D)imageCoord).getY() / this.ver_upp);
                    if (horIndex < 0 || horIndex >= this.iwidth || verIndex < 0 || verIndex >= this.iheight || (imageIndex = horIndex + verIndex * this.iwidth) < 0 || imageIndex >= this.pixels.length) continue;
                    tmpPixels[tmpIndex] = this.pixels[imageIndex];
                }
            }
            logger.fine("finished creating image");
            return tmpPixels;
        }
        logger.warning("problem creating image, no pixels: " + (this.pixels == null ? "true" : "false") + ", no projection:" + (p == null ? "true" : "false"));
        return null;
    }

    public DataBounds calculateProjectedImageBounds(Projection p) {
        DataBounds db = null;
        if (this.sourceImageBounds != null) {
            int pw = p.getWidth();
            int ph = p.getHeight();
            Point2D min = this.sourceImageBounds.getMin();
            Point2D max = this.sourceImageBounds.getMax();
            double x1 = Math.floor(min.getX());
            double y1 = Math.floor(min.getY());
            double x2 = Math.ceil(max.getX());
            double y2 = Math.ceil(max.getY());
            double width = this.sourceImageBounds.getWidth();
            double height = this.sourceImageBounds.getHeight();
            LatLonPoint.Double tmpG = new LatLonPoint.Double();
            Point2D.Double tmpP = new Point2D.Double();
            db = new DataBounds();
            db.setHardLimits(new DataBounds(0.0, 0.0, pw, ph));
            db.add(p.forward(this.geoTrans.inverse(x1, y1, tmpG), tmpP));
            db.add(p.forward(this.geoTrans.inverse(x1, y2, tmpG), tmpP));
            db.add(p.forward(this.geoTrans.inverse(x2, y1, tmpG), tmpP));
            db.add(p.forward(this.geoTrans.inverse(x2, y2, tmpG), tmpP));
            double numSplits = 4.0;
            double xSpacer = width / numSplits;
            double ySpacer = height / numSplits;
            int i = 1;
            while ((double)i < numSplits) {
                db.add(p.forward(this.geoTrans.inverse(Math.ceil(x1 + xSpacer * (double)i), y1, tmpG), tmpP));
                db.add(p.forward(this.geoTrans.inverse(x1, Math.ceil(y1 + ySpacer * (double)i), tmpG), tmpP));
                db.add(p.forward(this.geoTrans.inverse(Math.ceil(x1 + xSpacer * (double)i), y2, tmpG), tmpP));
                db.add(p.forward(this.geoTrans.inverse(x2, Math.ceil(y1 + ySpacer * (double)i), tmpG), tmpP));
                ++i;
            }
            if (db.getWidth() <= 0.0 || db.getHeight() <= 0.0) {
                logger.fine("dimensions of data bounds bad, returning null " + db);
                return null;
            }
        }
        return db;
    }

    public Rectangle getProjectedImageBoundsForLastProjection() {
        DataBounds projImageBounds = this.projectedImageBounds;
        Rectangle rect = null;
        if (projImageBounds != null) {
            int minx = (int)Math.floor(projImageBounds.getMin().getX());
            int miny = (int)Math.floor(projImageBounds.getMin().getY());
            int maxx = (int)Math.ceil(projImageBounds.getMax().getX());
            int maxy = (int)Math.ceil(projImageBounds.getMax().getY());
            rect = new Rectangle(minx, miny, maxx - minx, maxy - miny);
        }
        return rect;
    }

    protected int[] getPixels(Image img, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            Debug.error("ImageTranslator: interrupted waiting for pixels!");
            return new int[0];
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("ImageTranslator: image fetch aborted or errored");
            return new int[0];
        }
        return pixels;
    }

    public int getIwidth() {
        return this.iwidth;
    }

    public void setIwidth(int iwidth) {
        this.iwidth = iwidth;
    }

    public int getIheight() {
        return this.iheight;
    }

    public void setIheight(int iheight) {
        this.iheight = iheight;
    }

    public double getHor_dpp() {
        return this.hor_upp;
    }

    public void setHor_dpp(double hor_dpp) {
        this.hor_upp = hor_dpp;
    }

    public double getVer_dpp() {
        return this.ver_upp;
    }

    public void setVer_dpp(double ver_dpp) {
        this.ver_upp = ver_dpp;
    }

    public double getVerOrigin() {
        return this.verOrigin;
    }

    public void setVerOrigin(double verOrigin) {
        this.verOrigin = verOrigin;
    }

    public double getHorOrigin() {
        return this.horOrigin;
    }

    public void setHorOrigin(double horOrigin) {
        this.horOrigin = horOrigin;
    }

    public GeoCoordTransformation getGeoTrans() {
        return this.geoTrans;
    }

    public void setGeoTrans(GeoCoordTransformation geoTrans) {
        this.geoTrans = geoTrans;
    }

    public DataBounds getImageBounds() {
        return this.sourceImageBounds;
    }

    public void setImageBounds(DataBounds imageBounds) {
        this.sourceImageBounds = imageBounds;
        this.hor_upp = imageBounds.getWidth() / (double)this.iwidth;
        boolean yDirUp = imageBounds.isyDirUp();
        this.ver_upp = imageBounds.getHeight() / (double)this.iheight;
        if (yDirUp) {
            this.ver_upp *= -1.0;
        }
        double leftX = imageBounds.getMin().getX();
        double upperY = yDirUp ? imageBounds.getMax().getY() : imageBounds.getMin().getY();
        this.verOrigin = -upperY / this.ver_upp;
        this.horOrigin = -leftX / this.hor_upp;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getting image pixels w:" + this.iwidth + ", h:" + this.iheight + ", hor upp:" + this.hor_upp + ", ver upp:" + this.ver_upp + ", verOrigin:" + this.verOrigin + ", horOrigin:" + this.horOrigin);
            logger.fine(imageBounds.toString());
        }
    }

    public void setImageBounds(WorldFile worldFile) {
        this.hor_upp = worldFile.getXDim();
        this.ver_upp = worldFile.getYDim();
        double leftX = worldFile.getX();
        double upperY = worldFile.getY();
        this.verOrigin = -worldFile.getY() / this.ver_upp;
        this.horOrigin = -leftX / this.hor_upp;
        this.sourceImageBounds = new DataBounds(leftX, worldFile.getY() + this.ver_upp * (double)this.iheight, leftX + this.hor_upp * (double)this.iwidth, upperY);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getting image pixels w:" + this.iwidth + ", h:" + this.iheight + ", hor upp:" + this.hor_upp + ", ver upp:" + this.ver_upp + ", verOrigin:" + this.verOrigin + ", horOrigin:" + this.horOrigin);
            logger.fine(this.sourceImageBounds.toString());
        }
    }

    public static void main(String[] args) {
        new ImageWarp(new BufferedImage(100, 100, 2), (GeoCoordTransformation)LatLonGCT.INSTANCE, new DataBounds(25.0, -90.0, 180.0, 90.0));
    }
}

