/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.rule;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.omGraphics.rule.Rule;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleHandler<T>
extends OMComponent {
    List<Rule> rules;
    protected String lastLabel;

    public abstract Rule createRule();

    public abstract T getRecordDataForOMGraphic(OMGraphic var1);

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String rulesString = props.getProperty(prefix + "rules");
        Vector<String> keysV = PropUtils.parseSpacedMarkers(rulesString);
        if (keysV != null && !keysV.isEmpty()) {
            List<Rule> rules = Collections.synchronizedList(new LinkedList());
            for (String ruleMarker : keysV) {
                Rule rule = this.createRule();
                rule.setProperties(prefix + ruleMarker, props);
                rules.add(rule);
            }
            this.setRules(rules);
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer ruleList = new StringBuffer();
        int createdRuleNum = 1;
        for (Rule rule : this.getRules()) {
            String rulePrefix = rule.getPropertyPrefix();
            if (rulePrefix == null) {
                rulePrefix = "createdRulePrefix" + createdRuleNum++;
                rule.setPropertyPrefix(prefix + rulePrefix);
            }
            if (rulePrefix.startsWith(prefix) && (rulePrefix = rulePrefix.substring(prefix.length())).startsWith(".")) {
                rulePrefix = rulePrefix.substring(1);
            }
            ruleList.append(rulePrefix).append(" ");
            rule.getProperties(props);
        }
        if (ruleList.length() > 0) {
            props.put(prefix + "rules", ruleList.toString());
        }
        return props;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void addRule(Rule rule) {
        if (rule != null) {
            this.getRules().add(rule);
        }
    }

    public boolean removeRule(Rule rule) {
        if (rule != null) {
            return this.getRules().remove(rule);
        }
        return false;
    }

    public void clearRules() {
        this.getRules().clear();
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = Collections.synchronizedList(new LinkedList());
        }
        return this.rules;
    }

    public OMGraphic evaluate(OMGraphic omg, OMGraphicList labelList, Projection proj) {
        List<Rule> rules = this.getRules();
        if (rules.isEmpty()) {
            return omg;
        }
        T record = this.getRecordDataForOMGraphic(omg);
        if (record == null) {
            return omg;
        }
        OMGraphic passedEval = null;
        for (Rule rule : rules) {
            passedEval = rule.evaluate(record, omg, proj);
            if (passedEval == null) continue;
            Object labelObj = omg.getAttribute("Label");
            if (!(labelObj instanceof OMTextLabeler)) break;
            String curLabel = ((OMTextLabeler)labelObj).getData();
            if (this.lastLabel == null || this.lastLabel != null && !this.lastLabel.equalsIgnoreCase(curLabel)) {
                labelList.add((OMTextLabeler)labelObj);
            } else {
                omg.removeAttribute("Label");
            }
            this.lastLabel = curLabel;
            break;
        }
        return passedEval;
    }
}

