/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.rule;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.omGraphics.rule.Rule;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexRule
extends Rule<List<?>> {
    protected int keyIndex = -1;
    protected int[] tooltipIndicies;
    protected int[] infolineIndicies;
    protected int[] labelIndicies;

    public abstract int getRecordColumnIndexForName(String var1);

    public abstract String getRecordColumnName(int var1);

    @Override
    public boolean evaluate(List<?> record) {
        Object recVal = record.get(this.keyIndex);
        return this.op.evaluate(this.val, recVal);
    }

    @Override
    public String getContent(List<String> fieldNames, List<?> record) {
        StringBuffer buf = new StringBuffer();
        if (fieldNames != null) {
            for (String field : fieldNames) {
                int index = this.getRecordColumnIndexForName(field);
                buf.append(PropUtils.unnull(record.get(index))).append(" ");
            }
        }
        return buf.toString().trim();
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String key = props.getProperty(prefix + "key");
        this.keyIndex = this.getRecordColumnIndexForName(key);
        this.tooltipIndicies = this.getIndicies(this.tooltipFields);
        this.infolineIndicies = this.getIndicies(this.infolineFields);
        this.labelIndicies = this.getIndicies(this.labelFields);
    }

    @Override
    public OMGraphic evaluate(List<?> record, OMGraphic omg, Projection proj) {
        if (this.evaluate(record)) {
            float scale = 0.0f;
            if (proj != null && ((scale = proj.getScale()) < this.displayMinScale || scale > this.displayMaxScale)) {
                return null;
            }
            if (this.infolineIndicies != null) {
                omg.putAttribute("Information Line", this.getContentFromIndicies(this.infolineIndicies, record));
            }
            if (this.tooltipIndicies != null) {
                omg.putAttribute("Tooltip", this.getContentFromIndicies(this.tooltipIndicies, record));
            }
            if (this.labelIndicies != null && scale >= this.labelMinScale && scale <= this.labelMaxScale) {
                String curLabel = this.getContentFromIndicies(this.labelIndicies, record);
                OMTextLabeler label = new OMTextLabeler(curLabel, 1);
                omg.putAttribute("Label", label);
            }
            if (this.drawingAttributes != null) {
                this.drawingAttributes.setTo(omg);
            }
            omg.setVisible(this.drawingAttributes != null);
            return omg;
        }
        return null;
    }

    public String getContentFromIndicies(int[] indicies, List<?> record) {
        int numIndicies = indicies.length;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numIndicies; ++i) {
            int val = indicies[i];
            if (val == -1) continue;
            buf.append((String)record.get(val)).append(" ");
        }
        return buf.toString().trim();
    }

    public int[] getIndicies(List<String> fieldNames) {
        int[] indicies = null;
        if (fieldNames != null) {
            int numCols = fieldNames.size();
            indicies = new int[numCols];
            int i = 0;
            for (String columnName : fieldNames) {
                indicies[i++] = this.getRecordColumnIndexForName(columnName);
            }
        }
        return indicies;
    }

    public String getColumnNamesFromIndicies(int[] indicies) {
        StringBuffer buf = new StringBuffer();
        int numCols = indicies.length;
        for (int i = 0; i < numCols; ++i) {
            buf.append(this.getRecordColumnName(indicies[i])).append(" ");
        }
        return buf.toString().trim();
    }

    public int[] getInfolineIndicies() {
        return this.infolineIndicies;
    }

    public void setInfolineIndicies(int[] infolineIndicies) {
        this.infolineIndicies = infolineIndicies;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public int[] getLabelIndicies() {
        return this.labelIndicies;
    }

    public void setLabelIndicies(int[] labelIndicies) {
        this.labelIndicies = labelIndicies;
    }

    public int[] getTooltipIndicies() {
        return this.tooltipIndicies;
    }

    public void setTooltipIndicies(int[] tooltipIndicies) {
        this.tooltipIndicies = tooltipIndicies;
    }
}

