/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.GraphicSetOffsetState;
import com.bbn.openmap.omGraphics.editable.GraphicUndefinedState;
import com.bbn.openmap.omGraphics.editable.GraphicUnselectedState;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.stateMachine.State;
import com.bbn.openmap.util.stateMachine.StateMachine;

public class EOMGStateMachine
extends StateMachine {
    public EditableOMGraphic graphic;
    protected boolean offsetNeeded = false;
    public static final int GRAPHIC_UNDEFINED = 0;
    public static final int GRAPHIC_UNSELECTED = 1;
    public static final int GRAPHIC_SELECTED = 2;
    public static final int GRAPHIC_EDIT = 3;
    public static final int GRAPHIC_SETOFFSET = 4;
    public static final int DEFAULT_NUMBER_STATES = 5;
    public int NUMBER_STATES = 5;

    public EOMGStateMachine(EditableOMGraphic graphic) {
        this.graphic = graphic;
        this.setStates(this.init());
        this.setResetState(1);
        this.reset();
        this.setMapMouseListenerResponses(true);
        Debug.message("eomg", "EOMGStateMachine created");
    }

    protected State[] init() {
        Debug.message("eomg", "EOMGStateMachine.init()");
        State[] states = new State[this.NUMBER_STATES];
        states[0] = new GraphicUndefinedState(this.graphic);
        states[1] = new GraphicUnselectedState(this.graphic);
        states[2] = new GraphicSelectedState(this.graphic);
        states[3] = new GraphicEditState(this.graphic);
        states[4] = new GraphicSetOffsetState(this.graphic);
        return states;
    }

    public boolean isOffsetNeeded() {
        return this.offsetNeeded;
    }

    public void setOffsetNeeded(boolean set) {
        this.offsetNeeded = set;
    }

    public void setUndefined() {
        this.setState(0);
    }

    public void setUnselected() {
        this.setState(1);
    }

    public void setSelected() {
        this.setState(2);
    }

    public void setEdit() {
        this.setState(3);
    }

    public void setOffset() {
        this.setState(4);
    }
}

