/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.awt;

import com.bbn.openmap.omGraphics.awt.AbstractShapeDecoration;
import com.bbn.openmap.omGraphics.awt.LineUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class TextShapeDecoration
extends AbstractShapeDecoration {
    private String text;
    private Font font = null;
    private int verticalAlignment = 1;
    public static final int BASELINE = 1;
    public static final int CENTER = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int FORWARD = 2;
    public static final int BACKWARD = 1;
    public static final int LEFT_TO_RIGHT = 3;
    public static final int RIGHT_TO_LEFT = 4;
    public static final int TOP_TO_BOTTOM = 5;
    public static final int BOTTOM_TO_TOP = 6;
    public static final int MOST_READABLE = 7;
    public static final int FOLLOW_POLY = 16;
    private transient FontMetrics metrics;
    private transient Graphics2D g2D = null;

    public TextShapeDecoration(String text, Font font, int orientation, int verticalAlignment) {
        super(0.0f, 0.0f, orientation);
        this.setVerticalAlignment(verticalAlignment);
        this.setFont(font);
        this.setText(text);
        this.initMetrics();
    }

    public TextShapeDecoration(String text) {
        super(0.0f, 0.0f, 2);
        this.setVerticalAlignment(1);
        this.setText(text);
        this.initMetrics();
    }

    private void initMetrics() {
        if (this.g2D == null) {
            this.g2D = (Graphics2D)new BufferedImage(10, 10, 1).getGraphics();
        }
        if (this.font == null) {
            this.font = this.g2D.getFont();
        }
        this.metrics = this.g2D.getFontMetrics(this.font);
    }

    public void draw(Graphics g, Point2D[] points, boolean complete) {
        double angle;
        int y;
        int x;
        this.g2D = (Graphics2D)g;
        this.initMetrics();
        g.setFont(this.font);
        int x1 = (int)points[0].getX();
        int y1 = (int)points[0].getY();
        int x2 = (int)points[points.length - 1].getX();
        int y2 = (int)points[points.length - 1].getY();
        boolean reverse = this.needToReverse(x1, y1, x2, y2);
        if ((this.getOrientation() & 0x10) > 0) {
            this.drawFollow(g, points, reverse);
            return;
        }
        if (!complete) {
            return;
        }
        if (reverse) {
            x = x2;
            y = y2;
            angle = Math.atan2(y1 - y2, x1 - x2);
        } else {
            x = x1;
            y = y1;
            angle = Math.atan2(y2 - y1, x2 - x1);
        }
        switch (this.verticalAlignment) {
            case 3: {
                y += this.metrics.getAscent();
                break;
            }
            case 4: {
                y -= this.metrics.getDescent();
                break;
            }
            case 2: {
                y += this.metrics.getAscent() - this.metrics.getHeight() / 2;
                break;
            }
        }
        TextShapeDecoration.drawAngledString(g, this.text, x, y, angle);
    }

    protected boolean needToReverse(int x1, int y1, int x2, int y2) {
        boolean reverse = false;
        switch (this.getOrientation() & 0xFFFFFFEF) {
            case 2: {
                break;
            }
            case 1: {
                reverse = true;
                break;
            }
            case 3: {
                reverse = x1 > x2;
                break;
            }
            case 4: {
                reverse = x1 < x2;
                break;
            }
            case 5: {
                reverse = y1 > y2;
                break;
            }
            case 6: {
                reverse = y1 < y2;
                break;
            }
            case 7: {
                reverse = x2 < x1 || y1 > y2;
            }
        }
        return reverse;
    }

    protected void drawFollow(Graphics g, Point2D[] pts, boolean reverse) {
        int i;
        LinkedList<Point2D> points = new LinkedList<Point2D>();
        if (reverse) {
            for (i = pts.length - 1; i >= 0; --i) {
                points.add(pts[i]);
            }
        } else {
            for (i = 0; i < pts.length; ++i) {
                points.add(pts[i]);
            }
        }
        LinkedList<Point2D> polysegment = new LinkedList<Point2D>();
        for (int i2 = 0; i2 < this.text.length(); ++i2) {
            String c = this.text.substring(i2, i2 + 1);
            int l = this.metrics.stringWidth(c);
            if (points.isEmpty()) break;
            LineUtil.retrievePoints(l, points, polysegment);
            Point2D p1 = polysegment.getFirst();
            int x1 = (int)p1.getX();
            int y1 = (int)p1.getY();
            Point2D p2 = polysegment.getLast();
            int x2 = (int)p2.getX();
            int y2 = (int)p2.getY();
            double angle = Math.atan2(y2 - y1, x2 - x1);
            TextShapeDecoration.drawAngledString(g, c, x1, y1, angle);
        }
    }

    public static void drawAngledString(Graphics g, String text, int x, int y, double angle) {
        Graphics2D g2D = (Graphics2D)g;
        AffineTransform oldAt = g2D.getTransform();
        AffineTransform at = new AffineTransform(oldAt);
        at.rotate(angle, x, y);
        g2D.setTransform(at);
        g2D.drawString(text, x, y);
        g2D.setTransform(oldAt);
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        this.initMetrics();
    }

    public void setText(String text) {
        this.text = text;
        this.initMetrics();
        this.setLength(this.metrics.stringWidth(text));
        this.setWidth(this.metrics.getHeight());
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }
}

