/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import java.util.Hashtable;
import java.util.List;

public class DescribeDB {
    public static void println() {
        System.out.println();
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void println(String s1, String s2) {
        DescribeDB.println(s1 + s2);
    }

    public static void print(String s1, String s2) {
        DescribeDB.print(s1);
        DescribeDB.print(s2);
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static void main(String[] args) throws FormatException {
        for (int argsi = 0; argsi < args.length; ++argsi) {
            String rootpath = args[argsi];
            LibrarySelectionTable lst = new LibrarySelectionTable(rootpath);
            DescribeDB.println("Path to database: " + rootpath);
            DescribeDB.println("Database Name: " + lst.getDatabaseName());
            DescribeDB.println("Database Description: " + lst.getDatabaseDescription());
            List<String> libraries = lst.getLibraryNames();
            DescribeDB.print("Database Libraries: ");
            for (String libraryName : libraries) {
                DescribeDB.print(libraryName, " ");
            }
            DescribeDB.println();
            DescribeDB.println();
            for (String libraryName : libraries) {
                String prefix = libraryName + ":";
                DescribeDB.printLibrary(prefix, lst.getCAT(libraryName));
                DescribeDB.println();
            }
        }
    }

    public static void printLibrary(String prefix, CoverageAttributeTable cat) {
        int i;
        if (cat == null) {
            DescribeDB.println(prefix, "Library doesn't exist");
            return;
        }
        DescribeDB.println(prefix);
        String[] coverages = cat.getCoverageNames();
        DescribeDB.println(prefix, "uses " + (cat.isTiledData() ? "tiled" : "untiled") + " data");
        DescribeDB.print(prefix, "Coverage names:");
        for (i = 0; i < coverages.length; ++i) {
            DescribeDB.print(coverages[i]);
            DescribeDB.print(" ");
        }
        DescribeDB.println();
        for (i = 0; i < coverages.length; ++i) {
            DescribeDB.printCoverage(prefix + coverages[i] + ":", cat, coverages[i]);
        }
    }

    public static void printCoverage(String prefix, CoverageAttributeTable cat, String covname) {
        DescribeDB.println(prefix, "Coverage Description: " + cat.getCoverageDescription(covname));
        DescribeDB.println(prefix, "Coverage Topology Level: " + cat.getCoverageTopologyLevel(covname));
        CoverageTable ct = cat.getCoverageTable(covname);
        DescribeDB.print(prefix, "FeatureClassNames: ");
        DescribeDB.println();
        Hashtable<String, CoverageTable.FeatureClassRec> info = ct.getFeatureTypeInfo();
        for (CoverageTable.FeatureClassRec fcr : info.values()) {
            String tstring = "[unknown] ";
            if (fcr.type == 'T') {
                tstring = "[text feature] ";
            } else if (fcr.type == 'L') {
                tstring = "[edge feature] ";
            } else if (fcr.type == 'A') {
                tstring = "[area feature] ";
            } else if (fcr.type == 'P') {
                FeatureClassInfo fci = ct.getFeatureClassInfo(fcr.feature_class);
                tstring = fci == null ? "[point feature] " : (fci.getFeatureType() == 'E' ? "[entity point feature] " : (fci.getFeatureType() == 'N' ? "[connected point feature] " : "[point feature] "));
            } else if (fcr.type == 'C') {
                tstring = "[complex feature] ";
            }
            DescribeDB.println(prefix, fcr.feature_class + ": " + tstring + fcr.description);
        }
    }
}

